/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utility;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.annotation.DuplicateRule;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class DuplicateWarningsHandler {
    private final List<PvsStudioRule> rules;
    private final List<PvsStudioRule> duplicates;
    private final AnalyzerConfig config;

    public DuplicateWarningsHandler(AnalyzerConfig config, List<PvsStudioRule> rules) {
        this.rules = rules;
        this.config = config;
        this.duplicates = rules.stream().filter(rule -> ((Object)rule).getClass().isAnnotationPresent(DuplicateRule.class)).collect(Collectors.toList());
    }

    public void disableDuplicates() {
        List primaryRules = this.duplicates.stream().map(duplicateRule -> Pair.of((Object)((Object)((PvsStudioRule)this.rules.stream().filter(rule -> ((Object)duplicateRule).getClass().getAnnotation(DuplicateRule.class).primary().equals(((Object)rule).getClass())).findFirst().orElse(null))), (Object)duplicateRule)).collect(Collectors.toList());
        for (Pair pair2 : primaryRules) {
            PvsStudioRule primaryRule = (PvsStudioRule)((Object)pair2.getLeft());
            PvsStudioRule duplicateRule2 = (PvsStudioRule)((Object)pair2.getRight());
            if (this.config.disabledWarnings.contains(duplicateRule2.getName()) && !this.config.additionalWarnings.contains(primaryRule.getName())) {
                primaryRule.setEnabled(false);
            }
            if (!this.config.disabledWarnings.contains(primaryRule.getName()) || this.config.additionalWarnings.contains(duplicateRule2.getName())) continue;
            duplicateRule2.setEnabled(false);
        }
        List<Pair<String, String>> priorities = this.getPriorities();
        priorities.forEach(pair -> {
            PvsStudioRule higherPriorityRule = this.rules.stream().filter(rule -> rule.getName().equals(pair.getLeft())).findFirst().orElseThrow();
            PvsStudioRule lowerPriorityRule = this.rules.stream().filter(rule -> rule.getName().equals(pair.getRight())).findFirst().orElseThrow();
            if (higherPriorityRule.isEnabled()) {
                lowerPriorityRule.setEnabled(false);
            }
        });
    }

    public List<Pair<String, String>> getPriorities() {
        ArrayList<Pair<String, String>> priorities = new ArrayList<Pair<String, String>>();
        for (PvsStudioRule duplicateRule : this.duplicates) {
            String lowerPriorityRule;
            String higherPriorityRule;
            DuplicateRule duplicateAnnotation = ((Object)((Object)duplicateRule)).getClass().getAnnotation(DuplicateRule.class);
            String primaryRuleName = duplicateAnnotation.primary().getSimpleName();
            if (duplicateAnnotation.priority() == DuplicateRule.Priority.HIGH) {
                higherPriorityRule = duplicateRule.getName();
                lowerPriorityRule = primaryRuleName;
            } else {
                higherPriorityRule = primaryRuleName;
                lowerPriorityRule = duplicateRule.getName();
            }
            priorities.add((Pair<String, String>)Pair.of((Object)higherPriorityRule, (Object)lowerPriorityRule));
        }
        return priorities;
    }
}

