/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utility;

import com.pvsstudio.core.OptionalInt;
import com.pvsstudio.core.Value;
import com.pvsstudio.core.Variable;
import com.pvsstudio.core.VirtualValue;
import com.pvsstudio.dataflow.DataFlow;
import com.pvsstudio.dataflow.taint.utils.traverse.ReverseScanner;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.EarlyTerminatingScanner;

public class ArrayValueWrapper {
    private final DataFlow dataFlow;

    public ArrayValueWrapper(DataFlow dataFlow) {
        this.dataFlow = dataFlow;
    }

    @NotNull
    public final Value getValue(CtArrayRead<?> arrayRead) {
        Value defaultValue = this.dataFlow.getValue((CtElement)arrayRead);
        if (!(arrayRead.getTarget() instanceof CtVariableAccess)) {
            return defaultValue;
        }
        CtVariableReference variableReference = ((CtVariableAccess)arrayRead.getTarget()).getVariable();
        if (!this.isUsedOnlyIntroprocedural(variableReference)) {
            return defaultValue;
        }
        Optional<Integer> optionalIndex = Optional.of(this.dataFlow.getValue((CtElement)arrayRead.getIndexExpression())).map(Value::getVirtualValue).map(VirtualValue::toInt).filter(OptionalInt::isPresent).map(OptionalInt::get);
        if (optionalIndex.isEmpty()) {
            return defaultValue;
        }
        BigInteger index = BigInteger.valueOf(optionalIndex.get().intValue());
        Optional<Value> optionalValue = Optional.of(this.dataFlow.getValue((CtElement)arrayRead.getTarget())).map(Value::getVariable).map(variable -> variable.findArrayElement(index)).map(Variable::getValue).filter(value -> !value.isEmpty());
        return optionalValue.orElse(defaultValue);
    }

    public boolean isUsedOnlyIntroprocedural(final CtVariableReference<?> variable) {
        final MutableBoolean containsDeclaration = new MutableBoolean(false);
        final CtExecutable<?> executable = this.getParentExecutable((CtElement)variable);
        EarlyTerminatingScanner<Boolean> scanner = new EarlyTerminatingScanner<Boolean>(){
            private boolean oneMethodDepth = true;

            public <T> void visitCtLambda(CtLambda<T> lambda) {
                boolean memory = this.oneMethodDepth;
                this.oneMethodDepth = false;
                super.visitCtLambda(lambda);
                this.oneMethodDepth = memory;
            }

            public <T> void visitCtNewClass(CtNewClass<T> newClass) {
                boolean memory = this.oneMethodDepth;
                this.oneMethodDepth = false;
                super.visitCtNewClass(newClass);
                this.oneMethodDepth = memory;
            }

            public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
                if (arrayWrite.getTarget() instanceof CtVariableAccess) {
                    CtVariableAccess variableAccess = (CtVariableAccess)arrayWrite.getTarget();
                    if (!this.oneMethodDepth && variable.equals((Object)variableAccess.getVariable())) {
                        this.setResult(false);
                        this.terminate();
                        return;
                    }
                }
                super.visitCtArrayWrite(arrayWrite);
            }

            public <T> void visitCtParameter(CtParameter<T> parameter) {
                if (parameter.getReference().equals((Object)variable) && parameter.getParent() == executable) {
                    containsDeclaration.setTrue();
                }
            }

            public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
                if (localVariable.getReference().equals((Object)variable) && this.oneMethodDepth) {
                    containsDeclaration.setTrue();
                }
                super.visitCtLocalVariable(localVariable);
            }
        };
        scanner.scan(this.getParentExecutable((CtElement)variable));
        return !Boolean.FALSE.equals(scanner.getResult()) && containsDeclaration.isTrue();
    }

    @Nullable
    private CtExecutable<?> getParentExecutable(CtElement element) {
        final MutableObject executableMutableObject = new MutableObject(null);
        ReverseScanner scanner = new ReverseScanner(){

            @Override
            public <T> void visitCtLambda(CtLambda<T> ctLambda) {
                executableMutableObject.setValue(ctLambda);
            }

            @Override
            public <T> void visitCtNewClass(CtNewClass<T> ctNewClass) {
                executableMutableObject.setValue(null);
            }

            @Override
            public <T> void visitCtClass(CtClass<T> ctClass) {
            }

            @Override
            public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
            }

            @Override
            public <T> void visitCtInterface(CtInterface<T> ctInterface) {
            }

            @Override
            public <T> void visitCtMethod(CtMethod<T> ctMethod) {
                executableMutableObject.setValue(ctMethod);
            }

            @Override
            public <T> void visitCtConstructor(CtConstructor<T> ctConstructor) {
                executableMutableObject.setValue(ctConstructor);
            }
        };
        scanner.scan(element);
        return (CtExecutable)executableMutableObject.getValue();
    }
}

