/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.util.license;

import com.pvsstudio.PvsStudioException;
import com.pvsstudio.util.license.LicenseWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlLicenseWriter
extends LicenseWriter {
    protected XmlLicenseWriter(Path path) {
        super(path);
    }

    @Override
    public void write(String username, String key) throws IOException {
        try {
            File settingsFile = this.path.toFile();
            if (!settingsFile.exists()) {
                this.createDefaultXml(settingsFile);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            Document doc = factory.newDocumentBuilder().parse(settingsFile);
            doc.getDocumentElement().normalize();
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node usernameNode = (Node)xpath.compile("/ApplicationSettings/UserName").evaluate(doc, XPathConstants.NODE);
            usernameNode.setTextContent(username);
            Node keyNode = (Node)xpath.compile("/ApplicationSettings/SerialNumber").evaluate(doc, XPathConstants.NODE);
            keyNode.setTextContent(key);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(settingsFile);
            transformer.transform(source, result);
            System.out.println("Credentials were successfully written into " + this.path);
        }
        catch (ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            throw new PvsStudioException(e.getMessage(), e);
        }
    }

    private void createDefaultXml(File settingsFile) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = doc.createElement("ApplicationSettings");
            doc.appendChild(rootElement);
            Element userName = doc.createElement("UserName");
            userName.setTextContent(" ");
            rootElement.appendChild(userName);
            Element serialNumber = doc.createElement("SerialNumber");
            serialNumber.setTextContent(" ");
            rootElement.appendChild(serialNumber);
            try (FileOutputStream output = new FileOutputStream(settingsFile);){
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "html");
                transformer.transform(new DOMSource(doc), new StreamResult(output));
            }
        }
        catch (Exception e) {
            throw new PvsStudioException("Couldn't create " + settingsFile.getAbsolutePath());
        }
    }
}

