/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.util.license;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsStudioConfigException;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.util.license.LicLicenseWriter;
import com.pvsstudio.util.license.XmlLicenseWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.SystemUtils;

public abstract class LicenseWriter {
    protected final Path path;

    protected LicenseWriter(Path path) {
        this.path = path;
        this.ensureLicenseDirectoryExists();
    }

    public abstract void write(String var1, String var2) throws IOException;

    private void ensureLicenseDirectoryExists() {
        File fileDirectory = this.path.toFile().getParentFile();
        if (fileDirectory != null && !fileDirectory.exists() && !fileDirectory.mkdirs()) {
            throw new PvsStudioException("Directory " + fileDirectory + " does not exist and could not be created");
        }
    }

    public static LicenseWriter forConfig(AnalyzerConfig config) {
        Path licensePath;
        Path path = licensePath = config.licensePath != null ? Paths.get(config.licensePath, new String[0]) : null;
        if (licensePath != null) {
            String licenseFileName = licensePath.getFileName().toString();
            if (licenseFileName.endsWith(".lic")) {
                return new LicLicenseWriter(licensePath);
            }
            if (licenseFileName.endsWith(".xml")) {
                return new XmlLicenseWriter(licensePath);
            }
            throw new PvsStudioConfigException("The license file extension should be either .xml or .lic");
        }
        licensePath = Paths.get(AnalyzerConfig.PVS_LICENSE_FILE, new String[0]);
        if (SystemUtils.IS_OS_WINDOWS) {
            return new XmlLicenseWriter(licensePath);
        }
        if (SystemUtils.IS_OS_UNIX) {
            return new LicLicenseWriter(licensePath);
        }
        throw new IllegalStateException("Unsupported operating system");
    }

    public Path getPath() {
        return this.path;
    }
}

