/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.runner;

import com.google.common.base.Strings;
import com.pvsstudio.runner.AnalyzerProgress;
import com.pvsstudio.warnings.RawJson;
import com.pvsstudio.warnings.Warning;
import org.jetbrains.annotations.NotNull;

public class StdOutProgress
extends AnalyzerProgress {
    @Override
    public void progressModule(long percents, @NotNull String name) {
        System.out.printf("[%3d%%] Analyze module %s%n", percents, name);
    }

    @Override
    public void progressClass(long percents, @NotNull String name) {
        System.out.printf("[%3d%%] Analyze %s%n", percents, name);
    }

    @Override
    public void printAsRawJson(@NotNull Warning warning) {
        System.out.println(RawJson.GSON_CONFIG.toJson((Object)new RawJson(warning)));
    }

    @Override
    public void handleException(@NotNull Throwable exception, @NotNull String position, boolean showStackTrace) {
        System.out.println("Error: " + exception.getMessage());
        if (!Strings.isNullOrEmpty((String)position)) {
            System.out.println("at " + position);
        }
        if (showStackTrace) {
            exception.printStackTrace();
        }
    }
}

