/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.runner;

import com.pvsstudio.PvsStudioException;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.runner.PvsStudioAnalyzer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class RuleInitializer {
    private final PvsStudioAnalyzer analyzer;
    private final AnnotationService annotationService;
    private final List<PvsStudioRule> rules = new ArrayList<PvsStudioRule>();

    public RuleInitializer(@NotNull PvsStudioAnalyzer analyzer, @NotNull AnnotationService annotationService) {
        String packageName = PvsStudioRule.class.getPackage().getName();
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set ruleClasses = reflections.getSubTypesOf(PvsStudioRule.class);
        for (Class rule : ruleClasses) {
            if (Modifier.isAbstract(rule.getModifiers())) continue;
            try {
                this.rules.add((PvsStudioRule)((Object)rule.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new PvsStudioException("Failed to instantiate the rules", e);
            }
        }
        this.analyzer = analyzer;
        this.annotationService = annotationService;
    }

    public void initRules() {
        this.rules.forEach(rule -> rule.init(this.analyzer, this.annotationService));
    }

    public List<PvsStudioRule> getRules() {
        return this.rules;
    }
}

