/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.runner;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.core.FreeCommentsGenerated;
import com.pvsstudio.core.LicenseUtils;
import com.pvsstudio.dataflow.DataFlow;
import com.pvsstudio.dataflow.java.AnnotationSetter;
import com.pvsstudio.projects.Module;
import com.pvsstudio.rules.PrettyPrinter;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.runner.AnalyzerProgress;
import com.pvsstudio.timeout.TimeoutChecker;
import com.pvsstudio.timeout.TimeoutCheckerFactory;
import com.pvsstudio.utility.DuplicateWarningsHandler;
import com.pvsstudio.visitors.PvsStudioVisitor;
import com.pvsstudio.warnings.SuppressBase;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningsDuplicates;
import com.pvsstudio.warnings.WarningsSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtComment;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.reference.CtTypeReference;

public class PvsStudioAnalyzer {
    @NotNull
    private final List<PvsStudioRule> rules = new ArrayList<PvsStudioRule>();
    private WarningsSet warnings;
    @NotNull
    private final DataFlow dataFlow = new DataFlow(this);
    private final com.pvsstudio.dataflow.java.DataFlow javaDataFlow;
    private final AnnotationSetter annotationSetter;
    @NotNull
    private WeakReference<CtElement> lastVisitedElement = new WeakReference<Object>(null);
    @Nullable
    private PrettyPrinter printer;
    @NotNull
    private final List<String> suppressed = new ArrayList<String>();
    @NotNull
    private final List<CtAnnotation<?>> annotations = new ArrayList();
    @NotNull
    private final AnalyzerConfig config;
    private final TimeoutCheckerFactory timeoutCheckerFactory;
    private TimeoutChecker timeoutChecker;
    @NotNull
    private final AnalyzerProgress progress;
    @Nullable
    private Module module;
    private final AnnotationService annotationService;
    @NotNull
    private static final WarningsDuplicates RULE_PRIORITIES = new WarningsDuplicates().byPosition("V6001", "V6007").byPosition("V6038", "V6007").byPosition("V6003", "V6007").byPosition("V6039", "V6007").byPosition("V6060", "V6007").byPosition("V6005", "V6026").byPosition("V6065", "V6076").byPosition("V6007", "V6079").byPosition("V6093", "V6008").byPosition("V6104", "V6007");

    public com.pvsstudio.dataflow.java.DataFlow getJavaDataFlow() {
        return this.javaDataFlow;
    }

    @NotNull
    public AnnotationSetter getAnnotationSetter() {
        return this.annotationSetter;
    }

    public AnalyzerProgress getProgress() {
        return this.progress;
    }

    @Nullable
    public Module getModule() {
        return this.module;
    }

    public void setModule(@NotNull Module module) {
        this.module = module;
    }

    @NotNull
    public WarningsSet getWarnings() {
        return this.warnings;
    }

    @Nullable
    public CtElement getLastVisitedElement() {
        return (CtElement)this.lastVisitedElement.get();
    }

    public void setLastVisitedElement(@NotNull CtElement e) {
        this.lastVisitedElement = new WeakReference<CtElement>(e);
    }

    public AnnotationService getAnnotationService() {
        return this.annotationService;
    }

    public PvsStudioAnalyzer(@NotNull AnalyzerConfig config, @NotNull AnalyzerProgress progress, @NotNull AnnotationService annotationService, @NotNull AnnotationSetter annotationSetter, @NotNull com.pvsstudio.dataflow.java.DataFlow dataFlow, @NotNull TimeoutCheckerFactory timeoutCheckerFactory) {
        this(config, progress, annotationService, annotationSetter, dataFlow, timeoutCheckerFactory, new ConcurrentHashMap(), List.of(), Set.of());
    }

    @Inject
    public PvsStudioAnalyzer(@NotNull AnalyzerConfig config, @NotNull AnalyzerProgress progress, @NotNull AnnotationService annotationService, @NotNull AnnotationSetter annotationSetter, @NotNull com.pvsstudio.dataflow.java.DataFlow dataFlow, @NotNull TimeoutCheckerFactory timeoutCheckerFactory, @Named(value="annotationCache") @NotNull Map<String, CtTypeReference<?>> annotationCache, @Named(value="rules") @NotNull List<PvsStudioRule> rules, @Named(value="warnings") @NotNull Set<Warning> warnings) {
        this.config = config;
        this.progress = progress;
        this.dataFlow.setCacheAnnotations(annotationCache);
        this.annotationSetter = annotationSetter;
        this.javaDataFlow = dataFlow;
        this.warnings = this.config.writeToStdout.booleanValue() ? new WarningsSet(this.progress::printAsRawJson) : WarningsSet.createNew();
        this.warnings.addAll((Collection<? extends Warning>)warnings);
        rules.forEach(rule -> rule.init(this, annotationService));
        this.rules.addAll(rules);
        DuplicateWarningsHandler duplicateHandler = new DuplicateWarningsHandler(this.config, this.rules);
        duplicateHandler.disableDuplicates();
        this.annotationService = annotationService;
        this.timeoutCheckerFactory = timeoutCheckerFactory;
    }

    public void checkState() {
        this.timeoutChecker.assertNotTimeout();
        this.progress.ensureNotCancelled();
    }

    private boolean hasFreeLicenseComment(@NotNull List<CtComment> comments) {
        if (comments.isEmpty()) {
            return false;
        }
        String firstCommentContent = comments.get(0).getContent().toLowerCase().trim();
        for (int i = 0; i < FreeCommentsGenerated.comments.length; i += 2) {
            String secondCommentContent;
            String header = FreeCommentsGenerated.comments[i].toLowerCase().trim();
            String footer = FreeCommentsGenerated.comments[i + 1].toLowerCase().trim();
            if (!firstCommentContent.startsWith(header)) continue;
            if (firstCommentContent.endsWith(footer)) {
                return StringUtils.isBlank((CharSequence)firstCommentContent.replace(header, "").replace(footer, ""));
            }
            if (comments.size() <= 1 || !(secondCommentContent = comments.get(1).getContent().toLowerCase().trim()).equals(footer) || !firstCommentContent.endsWith(header)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(@NotNull Module module, @NotNull SuppressBase suppressBase, @NotNull CtTypeMember ctTopType) {
        if (LicenseUtils.isFreeLicense(this.config.getUserName()) && !this.hasFreeLicenseComment(module.getComments(ctTopType.getPosition().getFile(), 1, 10).stream().filter(comment -> comment.getCommentType() == CtComment.CommentType.FILE).filter(comment -> StringUtils.isNotBlank((CharSequence)comment.getContent())).collect(Collectors.toList()))) {
            this.warnings.add(Warning.noFreeLicenseMessage(ctTopType.getPosition().getFile().getAbsolutePath()));
            return;
        }
        this.timeoutChecker = this.timeoutCheckerFactory.timeoutCheckerWithCurrentTimestamp();
        WarningsSet oldWarnings = this.warnings;
        this.warnings = WarningsSet.createNew();
        try {
            if (this.getModule() != module) {
                this.dataFlow.getTypesCache().clear();
                this.javaDataFlow.setGraphModel(module.getGraphModel());
            }
            this.setLastVisitedElement((CtElement)ctTopType);
            this.printer = new PrettyPrinter(ctTopType.getFactory().getEnvironment(), module);
            this.setModule(module);
            new PvsStudioVisitor(this).scan((CtElement)ctTopType);
            this.lastVisitedElement.clear();
        }
        catch (Throwable throwable) {
            this.rules.forEach(PvsStudioRule::clear);
            RULE_PRIORITIES.removeFrom(this.warnings);
            this.warnings.removeIf((Predicate<? super Warning>)((Predicate<Warning>)suppressBase::isSuppressed));
            AnalyzerConfig analyzerConfig = Objects.requireNonNull(this.getModule()).getProject().getConfig();
            if (!StringUtils.isEmpty((CharSequence)analyzerConfig.sourceTreeRoot)) {
                this.warnings.makeRelativePaths(analyzerConfig.sourceTreeRoot);
            }
            oldWarnings.addAll(this.warnings);
            this.warnings = oldWarnings;
            this.dataFlow.clear();
            this.annotations.clear();
            this.suppressed.clear();
            throw throwable;
        }
        this.rules.forEach(PvsStudioRule::clear);
        RULE_PRIORITIES.removeFrom(this.warnings);
        this.warnings.removeIf((Predicate<? super Warning>)((Predicate<Warning>)suppressBase::isSuppressed));
        AnalyzerConfig analyzerConfig = Objects.requireNonNull(this.getModule()).getProject().getConfig();
        if (!StringUtils.isEmpty((CharSequence)analyzerConfig.sourceTreeRoot)) {
            this.warnings.makeRelativePaths(analyzerConfig.sourceTreeRoot);
        }
        oldWarnings.addAll(this.warnings);
        this.warnings = oldWarnings;
        this.dataFlow.clear();
        this.annotations.clear();
        this.suppressed.clear();
    }

    @NotNull
    public PrettyPrinter getPrinter() {
        return Objects.requireNonNull(this.printer);
    }

    @NotNull
    public String print(@NotNull CtCodeElement e) {
        if (this.printer == null) {
            throw new PvsStudioException("AST printer was not initialized");
        }
        return this.printer.print((CtElement)e);
    }

    @NotNull
    public DataFlow getDataFlow() {
        return this.dataFlow;
    }

    @NotNull
    public List<PvsStudioRule> getRules() {
        return this.rules;
    }

    @NotNull
    public <T> T getRule(Class<T> c) {
        return (T)this.rules.stream().filter(c::isInstance).map(c::cast).findFirst().orElseThrow(() -> new PvsStudioException("Couldn't find " + c.getSimpleName() + " rule"));
    }

    @NotNull
    public List<String> getSuppressed() {
        return this.suppressed;
    }

    @NotNull
    public List<CtAnnotation<?>> getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public AnalyzerConfig getConfig() {
        return this.config;
    }
}

