/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.runner;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.JavaVersion;
import com.pvsstudio.JdkRuntimeUtils;
import com.pvsstudio.PvsStudioException;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLoader {
    private static final Logger logger = LoggerFactory.getLogger(NativeLoader.class);
    private static Field classLoaderLibraryNamesFiled;
    private static final String LOADED_LIBRARY_NAMES = "loadedLibraryNames";
    private static final String JDK_OLDER_THAN_13_VERSION_CLASS_WITH_LOADED_LIBRARY_NAMES_FIELD = "jdk.internal.loader.NativeLibraries";
    private static boolean isLoaded;

    private NativeLoader() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean trySetAccessToFieldLoadedLibraryNames(boolean logExceptions) {
        if (classLoaderLibraryNamesFiled != null && classLoaderLibraryNamesFiled.isAccessible()) {
            return true;
        }
        try {
            classLoaderLibraryNamesFiled = ClassLoader.class.getDeclaredField(LOADED_LIBRARY_NAMES);
            classLoaderLibraryNamesFiled.setAccessible(true);
            return true;
        }
        catch (Throwable classLoaderFieldException) {
            if (JdkRuntimeUtils.isJavaVersionAtLeast(JavaVersion.JAVA_14)) {
                try {
                    Class<?> clazz = Class.forName(JDK_OLDER_THAN_13_VERSION_CLASS_WITH_LOADED_LIBRARY_NAMES_FIELD);
                    classLoaderLibraryNamesFiled = clazz.getDeclaredField(LOADED_LIBRARY_NAMES);
                    classLoaderLibraryNamesFiled.setAccessible(true);
                    return true;
                }
                catch (Throwable nativeLibrariesFieldException) {
                    if (!logExceptions) return false;
                    NativeLoader.logStaticInitializerException(JDK_OLDER_THAN_13_VERSION_CLASS_WITH_LOADED_LIBRARY_NAMES_FIELD, nativeLibrariesFieldException);
                    return false;
                }
            } else {
                if (!logExceptions) return false;
                NativeLoader.logStaticInitializerException(ClassLoader.class.getCanonicalName(), classLoaderFieldException);
            }
            return false;
        }
    }

    private static void logStaticInitializerException(String className, Throwable exception) {
        logger.warn("Cannot find field loadedLibraryNames in class " + className + " with java version " + SystemUtils.JAVA_SPECIFICATION_VERSION, exception);
    }

    private static boolean topClassLoaderAlreadyLoadNativeLibraryWithAbsolutePath(@NotNull String nativeLibraryAbsolutePath) {
        try {
            ClassLoader parent;
            ClassLoader currentClassLoader = ClassLoader.getSystemClassLoader();
            while ((parent = currentClassLoader.getParent()) != null) {
                currentClassLoader = parent;
            }
            return ((Collection)classLoaderLibraryNamesFiled.get(currentClassLoader)).contains(nativeLibraryAbsolutePath);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void run() {
        String nativeLibsExtension;
        String nativePath;
        if (SystemUtils.IS_OS_WINDOWS) {
            nativePath = "native/win";
            nativeLibsExtension = ".dll";
        } else if (SystemUtils.IS_OS_MAC) {
            if (SystemUtils.OS_ARCH.contains("arm64") || SystemUtils.OS_ARCH.contains("aarch64")) {
                nativePath = "native/mac_arm64";
                nativeLibsExtension = ".dylib";
            } else {
                nativePath = "native/mac";
                nativeLibsExtension = ".dylib";
            }
        } else {
            nativePath = "native/nix";
            nativeLibsExtension = ".so";
        }
        try {
            if (!SystemUtils.IS_OS_MAC) {
                NativeLoader.loadAdditionalNativeLibraries(nativeLibsExtension, "jvm");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        String classpath = AnalyzerConfig.getJavaCoreExecutableJar(this.getClass()).getParent();
        String[] path = new String[]{classpath, ".", Paths.get(classpath, "..").toString(), Paths.get(classpath, "../../").toString(), Paths.get(classpath, "../../build").toString()};
        logger.info("********************************");
        logger.info("Native library search paths: ");
        Arrays.stream(path).forEach(arg_0 -> ((Logger)logger).info(arg_0));
        logger.info("Additional path: {}", (Object)nativePath);
        File f = Stream.of(path).map(s -> Paths.get(s, nativePath, System.mapLibraryName("analysis-core")).toString()).map(File::new).filter(File::exists).max(Comparator.comparingLong(File::lastModified)).orElseThrow(() -> new PvsStudioException("Unable to locate native library"));
        logger.info("Native library found: {}", (Object)f.getAbsolutePath());
        logger.info("********************************");
        System.load(f.getAbsolutePath());
    }

    private static void loadAdditionalNativeLibraries(@NotNull String libExtension, String ... libsNames) {
        if (!NativeLoader.trySetAccessToFieldLoadedLibraryNames(true)) {
            return;
        }
        logger.info("********************************");
        logger.info("Additional native libraries search paths: ");
        String[] librarySearchPaths = System.getProperty("sun.boot.library.path").split(File.pathSeparator);
        Arrays.stream(librarySearchPaths).forEach(arg_0 -> ((Logger)logger).info(arg_0));
        HashSet foundedLibsAbsolutePaths = new HashSet();
        for (String path : librarySearchPaths) {
            File fileFromPath = new File(path);
            if (!fileFromPath.exists()) continue;
            foundedLibsAbsolutePaths.addAll(FileUtils.listFiles((File)fileFromPath, (IOFileFilter)new SuffixFileFilter(libExtension), (IOFileFilter)TrueFileFilter.INSTANCE).stream().map(File::getAbsolutePath).filter(absolutePath -> Arrays.stream(libsNames).anyMatch(libName -> absolutePath.endsWith(libName + libExtension))).collect(Collectors.toList()));
        }
        HashSet<String> notLoadedNativeLibraries = new HashSet<String>();
        for (String foundedLibAbsolutePath : foundedLibsAbsolutePaths) {
            if (NativeLoader.topClassLoaderAlreadyLoadNativeLibraryWithAbsolutePath(foundedLibAbsolutePath)) {
                logger.info("Native library already loaded in top ClassLoader. Library path: " + foundedLibAbsolutePath);
                continue;
            }
            notLoadedNativeLibraries.add(foundedLibAbsolutePath);
        }
        for (String absolutePath2 : notLoadedNativeLibraries) {
            System.load(absolutePath2);
            logger.info("Additional not loaded native library found: {}", (Object)absolutePath2);
        }
        logger.info("********************************");
    }

    public static boolean isLoaded() {
        return isLoaded;
    }

    public static void loadInCheckLicenseProcess() {
        logger.info("Start check license in other process");
        NativeLoader.load();
        logger.info("End check license in other process");
    }

    public static void load() {
        if (!isLoaded) {
            NativeLoader loader = new NativeLoader();
            loader.run();
            isLoaded = true;
        }
    }

    static {
        isLoaded = false;
    }
}

