/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.runner;

import com.pvsstudio.PvsStudioBuildException;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.annotation.AnnotationProcessor;
import com.pvsstudio.projects.Module;
import com.pvsstudio.runner.AnalysisCancelledException;
import com.pvsstudio.runner.AnalyzerProgress;
import com.pvsstudio.runner.AnalyzerWorker;
import com.pvsstudio.runner.Benchmark;
import com.pvsstudio.runner.NativeLoader;
import com.pvsstudio.warnings.SuppressBase;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningsSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.declaration.CtType;

public class ModuleModelBuilder {
    @NotNull
    private static final Logger logger = LoggerFactory.getLogger(ModuleModelBuilder.class);
    @NotNull
    private final WarningsSet warnings;
    @NotNull
    private final Module module;
    @NotNull
    private final ExecutorService threadPool;
    private final AnalyzerProgress.ModuleProgress moduleProgress;
    @NotNull
    private final AnalyzerProgress progress;
    @NotNull
    private final SuppressBase suppressBase;
    private final boolean checkNativeLibrariesLoadedCorrected;
    private final AnnotationProcessor annotationProcessor;

    protected ModuleModelBuilder(@NotNull AnalyzerProgress.ModuleProgress progress, @NotNull ExecutorService pool, @NotNull Module module, @NotNull WarningsSet warnings, @NotNull SuppressBase suppressBase, @NotNull AnnotationProcessor annotationProcessor, boolean checkNativeLibrariesLoadedCorrected) {
        logger.debug(module.getName());
        this.warnings = warnings;
        this.suppressBase = suppressBase;
        this.module = module;
        this.threadPool = pool;
        this.progress = progress.getProgress();
        this.moduleProgress = progress;
        this.annotationProcessor = annotationProcessor;
        this.checkNativeLibrariesLoadedCorrected = checkNativeLibrariesLoadedCorrected;
    }

    @Nullable
    protected ModuleWorker createModuleWorkerWithBuiltModelAndAnalyzeTasksForModule() {
        boolean buildSuccess = false;
        try {
            if (this.checkNativeLibrariesLoadedCorrected && NativeLoader.isLoaded()) {
                throw new PvsStudioException("Native libs must not be loaded before calling the ModuleModelBuilder.createModuleWorkerWithBuiltModelAndAnalyzeTasksForModule method.");
            }
            this.progress.ensureNotCancelled();
            this.moduleProgress.startBuild();
            long start = System.currentTimeMillis();
            this.module.build();
            Benchmark.instance().build(this.module.getName(), System.currentTimeMillis() - start);
            this.moduleProgress.finishBuild();
            this.module.buildGraphModel();
            start = System.currentTimeMillis();
            this.annotationProcessor.annotateModel(this.module.getModel());
            Benchmark.instance().annotate(this.module.getName(), System.currentTimeMillis() - start);
            buildSuccess = true;
            this.progress.ensureNotCancelled();
            List<Callable<Object>> moduleAnalyzeTasks = this.module.getModel().getAllTypes().stream().filter(CtType::isTopLevel).filter(ctTopType -> !this.module.isExcluded((CtType<?>)ctTopType)).map(ctTopType -> new AnalyzerWorker(this.moduleProgress, this.module, (CtType<?>)ctTopType, this.suppressBase)).map(Executors::callable).collect(Collectors.toUnmodifiableList());
            return new ModuleWorker(this, moduleAnalyzeTasks, this.checkNativeLibrariesLoadedCorrected);
        }
        catch (AnalysisCancelledException start) {
        }
        catch (Throwable e) {
            if (buildSuccess) {
                Warning warning = new Warning(e);
                this.progress.handleException(e);
                this.warnings.add(warning);
            }
            throw new PvsStudioBuildException(String.format("Unable to start the analysis on '%s' module.", this.module.getName()), e);
        }
        return null;
    }

    protected static class ModuleWorker {
        @NotNull
        private final ModuleModelBuilder moduleModelBuilder;
        private final List<Callable<Object>> moduleAnalyzeTasks;
        private final boolean checkNativeLibrariesLoadedCorrected;

        private ModuleWorker(@NotNull ModuleModelBuilder moduleModelBuilder, @NotNull List<Callable<Object>> moduleAnalyzeTasks, boolean checkNativeLibrariesLoadedCorrected) {
            this.moduleModelBuilder = moduleModelBuilder;
            this.moduleAnalyzeTasks = moduleAnalyzeTasks;
            this.checkNativeLibrariesLoadedCorrected = checkNativeLibrariesLoadedCorrected;
        }

        public void runClassesAnalysisTasksFromModule() {
            try {
                if (this.checkNativeLibrariesLoadedCorrected && !NativeLoader.isLoaded()) {
                    throw new PvsStudioException("Native libs must be loaded before calling the ModuleWorker.runModuleClassesAnalyzeTasks method.");
                }
                this.moduleModelBuilder.progress.ensureNotCancelled();
                this.moduleModelBuilder.moduleProgress.start();
                this.moduleModelBuilder.threadPool.invokeAll(this.moduleAnalyzeTasks);
            }
            catch (AnalysisCancelledException analysisCancelledException) {
            }
            catch (InterruptedException e) {
                this.moduleModelBuilder.progress.cancel();
                Thread.currentThread().interrupt();
            }
            catch (RejectedExecutionException e) {
                this.moduleModelBuilder.progress.cancel();
            }
            catch (Throwable e) {
                this.moduleModelBuilder.progress.handleException(e);
                this.moduleModelBuilder.warnings.add(new Warning(e).addStacktrace(e));
            }
            finally {
                this.moduleModelBuilder.moduleProgress.finish();
                this.moduleModelBuilder.module.clear();
            }
        }
    }
}

