/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.runner;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Benchmark
implements Serializable {
    public static final long serialVersionUID = 1L;
    @SerializedName(value="classes")
    private Map<String, Long> classes = new HashMap<String, Long>();
    @SerializedName(value="functions")
    private Map<String, Long> functions = new HashMap<String, Long>();
    @SerializedName(value="rules")
    private Map<String, Long> rules = new HashMap<String, Long>();
    @SerializedName(value="modules")
    private Map<String, Long> modules = new HashMap<String, Long>();
    @SerializedName(value="steps")
    private Map<String, Long> steps = new HashMap<String, Long>();
    @SerializedName(value="memory")
    private Map<String, Long> memory = new HashMap<String, Long>();
    private static boolean isActive = false;
    private static final Collection<Benchmark> ALL_INSTANCES = new ArrayList<Benchmark>();
    private static final ThreadLocal<Benchmark> INSTANCE = ThreadLocal.withInitial(() -> {
        Benchmark result = new Benchmark();
        ALL_INSTANCES.add(result);
        return result;
    });

    public static Benchmark instance() {
        return INSTANCE.get();
    }

    private void add(Map<String, Long> map, String name, long elapsed) {
        map.compute(name, (n, old) -> old == null ? elapsed : elapsed + old);
    }

    private void max(Map<String, Long> map, String name, long count) {
        map.compute(name, (n, old) -> old == null ? count : Math.max(old, count));
    }

    public static boolean isActive() {
        return isActive;
    }

    public static void setActive(boolean active) {
        isActive = active;
    }

    public void step(String name, long elapsed) {
        if (isActive) {
            this.add(this.steps, name, elapsed);
        }
    }

    public void step(String name, Runnable fn) {
        long time = System.currentTimeMillis();
        fn.run();
        if (isActive) {
            this.add(this.steps, name, System.currentTimeMillis() - time);
        }
    }

    public <T> T step(String name, Supplier<T> fn) {
        long time = System.currentTimeMillis();
        T result = fn.get();
        if (isActive) {
            this.add(this.steps, name, System.currentTimeMillis() - time);
        }
        return result;
    }

    public void analysis(String name, long elapsed) {
        if (isActive) {
            this.add(this.classes, name, elapsed);
            this.add(this.steps, "Static analysis", elapsed);
        }
    }

    public void build(String name, long elapsed) {
        if (isActive) {
            this.add(this.modules, name, elapsed);
            this.add(this.steps, "Building model", elapsed);
        }
    }

    public void annotate(String name, long elapsed) {
        if (isActive) {
            this.add(this.modules, name, elapsed);
            this.add(this.steps, "Annotating model (Java)", elapsed);
        }
    }

    public void function(String name, long elapsed) {
        if (isActive) {
            this.add(this.functions, name, elapsed);
        }
    }

    public void memory(String name, long count) {
        if (isActive) {
            this.max(this.memory, name, count / 1024L / 1024L);
        }
    }

    public void rule(String name, Runnable fn) {
        long time = System.currentTimeMillis();
        fn.run();
        if (isActive) {
            long elapsed = System.currentTimeMillis() - time;
            this.add(this.rules, name, elapsed);
            this.add(this.steps, "Static analysis: rules", elapsed);
        }
    }

    private void dumpMap(Map<String, Long> map, String name, String suffix, int limit) {
        if (map.isEmpty()) {
            return;
        }
        System.out.println();
        System.out.println("|" + StringUtils.repeat((char)'-', (int)118) + "|");
        System.out.println("|" + StringUtils.center((String)String.format("Top %d %s", Math.min(limit, map.size()), name), (int)118, (char)' ') + "|");
        System.out.println("|" + StringUtils.repeat((char)'-', (int)118) + "|");
        new ArrayList<Map.Entry<String, Long>>(map.entrySet()).stream().sorted(Map.Entry.comparingByValue().reversed()).limit(limit).forEachOrdered(e -> System.out.printf("| %-105s | %8s |%n", e.getKey(), String.valueOf(e.getValue()) + suffix));
        System.out.println("|" + StringUtils.repeat((char)'-', (int)118) + "|");
        System.out.println();
    }

    private Map<String, Long> sorted(Map<String, Long> original) {
        return new ArrayList<Map.Entry<String, Long>>(original.entrySet()).stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    public void sort() {
        this.steps = this.sorted(this.steps);
        this.modules = this.sorted(this.modules);
        this.classes = this.sorted(this.classes);
        this.functions = this.sorted(this.functions);
        this.rules = this.sorted(this.rules);
        this.memory = this.sorted(this.memory);
    }

    public void dumpToStdout() {
        this.dumpMap(this.steps, "steps", "ms", Integer.MAX_VALUE);
        this.dumpMap(this.modules, "modules", "ms", 10);
        this.dumpMap(this.classes, "classes", "ms", 10);
        this.dumpMap(this.functions, "functions", "ms", 10);
        this.dumpMap(this.rules, "rules", "ms", Integer.MAX_VALUE);
        this.dumpMap(this.memory, "memory hogs", "mb", Integer.MAX_VALUE);
    }

    private void merge(Map<String, Long> a, Map<String, Long> b) {
        b.forEach((name, value) -> this.add(a, (String)name, (long)value));
    }

    public void merge(@NotNull Benchmark other) {
        this.merge(this.steps, other.steps);
        this.merge(this.modules, other.modules);
        this.merge(this.classes, other.classes);
        this.merge(this.functions, other.functions);
        this.merge(this.rules, other.rules);
        this.mergeMax(this.memory, other.memory);
    }

    private void mergeMax(Map<String, Long> a, Map<String, Long> b) {
        b.forEach((name, value) -> this.max(a, (String)name, (long)value));
    }

    public static Benchmark collect() {
        Benchmark result = new Benchmark();
        for (Benchmark instance : ALL_INSTANCES) {
            result.merge(instance);
        }
        return result;
    }
}

