/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.runner;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsStudioTimeoutException;
import com.pvsstudio.Version;
import com.pvsstudio.projects.Module;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.runner.AnalysisCancelledException;
import com.pvsstudio.runner.AnalyzerProgress;
import com.pvsstudio.runner.AnalyzerThread;
import com.pvsstudio.runner.Benchmark;
import com.pvsstudio.runner.PvsStudioAnalyzer;
import com.pvsstudio.warnings.SuppressBase;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;

public class AnalyzerWorker
implements Runnable {
    private static final String EXCEPTION_DURING_ANALYSIS_MESSAGE = "An exception had occurred during analysis.";
    private static final Logger logger = LoggerFactory.getLogger(AnalyzerWorker.class);
    @NotNull
    private final AnalyzerProgress.ModuleProgress moduleProgress;
    @NotNull
    private final Module module;
    @NotNull
    private final CtType<?> ctTopType;
    @NotNull
    private final SuppressBase suppressBase;

    AnalyzerWorker(@NotNull AnalyzerProgress.ModuleProgress progress, @NotNull Module module, @NotNull CtType<?> ctTopType, @NotNull SuppressBase suppressBase) {
        this.moduleProgress = progress;
        this.module = module;
        this.ctTopType = ctTopType;
        this.suppressBase = suppressBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PvsStudioAnalyzer analyzer = ((AnalyzerThread)Thread.currentThread()).getAnalyzer();
        try {
            this.moduleProgress.getProgress().ensureNotCancelled();
            this.moduleProgress.startClass(this.ctTopType.getQualifiedName());
            logger.debug("Start analyze: {}", (Object)this.ctTopType.getQualifiedName());
            long start = System.currentTimeMillis();
            analyzer.analyze(this.module, this.suppressBase, (CtTypeMember)this.ctTopType);
            Benchmark.instance().analysis(this.ctTopType.getQualifiedName(), System.currentTimeMillis() - start);
        }
        catch (AnalysisCancelledException start) {
        }
        catch (PvsStudioTimeoutException timeoutException) {
            Warning warning = new Warning(timeoutException);
            warning.addSourcePosition(RulesUtils.getPosition(analyzer.getLastVisitedElement(), this.module));
            analyzer.getWarnings().add(warning);
            this.writeToLog(timeoutException, analyzer);
        }
        catch (Throwable e) {
            AnalyzerConfig config = this.module.getProject().getConfig();
            String V061WarningMessage = this.module.getLauncher().buildingFromScratch() ? (config.loggingIsEnabled() && config.debugLog != null ? String.format("An exception had occurred during analysis. Detailed logs are located at '%s'.", config.debugLog) : EXCEPTION_DURING_ANALYSIS_MESSAGE) : String.format("An exception had occurred during analysis. Perhaps, the model have been damaged. Delete '%s/%s' and run the analysis again.", config.projectPath, ".PVS-Studio/models");
            analyzer.getWarnings().add(new Warning("V061", V061WarningMessage, WarningLevel.LEVEL_0, RulesUtils.getPosition(analyzer.getLastVisitedElement(), this.module)).addStacktrace(e));
            this.writeToLog(e, analyzer);
        }
        finally {
            this.moduleProgress.finishClass();
        }
    }

    private void writeToLog(Throwable e, PvsStudioAnalyzer analyzer) {
        String failedPosition = Optional.ofNullable(analyzer.getLastVisitedElement()).map(CtElement::getPosition).map(pos -> " See " + String.valueOf(pos)).orElse("");
        if (Version.isDevelopment()) {
            this.moduleProgress.getProgress().handleException(e, failedPosition);
        }
        logger.error("The exception during analysis.{}", (Object)failedPosition, (Object)e);
    }
}

