/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.runner;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.pvsstudio.runner.AnalyzerThread;
import com.pvsstudio.runner.PvsStudioAnalyzer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NotNull;

public class AnalyzerThreadFactory
implements ThreadFactory {
    private final List<PvsStudioAnalyzer> analyzers = new ArrayList<PvsStudioAnalyzer>();
    private final Provider<PvsStudioAnalyzer> analyzerProvider;

    @Inject
    public AnalyzerThreadFactory(Provider<PvsStudioAnalyzer> analyzerProvider) {
        this.analyzerProvider = analyzerProvider;
    }

    @Override
    public synchronized Thread newThread(@NotNull Runnable task) {
        PvsStudioAnalyzer analyzer = (PvsStudioAnalyzer)this.analyzerProvider.get();
        this.analyzers.add(analyzer);
        return new AnalyzerThread("Analyzer-Thread-" + this.analyzers.size(), analyzer, task);
    }

    public List<PvsStudioAnalyzer> getAnalyzers() {
        return this.analyzers;
    }
}

