/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.runner;

import com.google.gson.JsonParseException;
import com.google.inject.Inject;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsStudioBuildException;
import com.pvsstudio.PvsStudioInvoker;
import com.pvsstudio.annotation.AnnotationProcessor;
import com.pvsstudio.projects.Module;
import com.pvsstudio.projects.Project;
import com.pvsstudio.runner.AnalyzerProgress;
import com.pvsstudio.runner.AnalyzerThreadFactory;
import com.pvsstudio.runner.Benchmark;
import com.pvsstudio.runner.CancellationChecker;
import com.pvsstudio.runner.ModuleModelBuilder;
import com.pvsstudio.runner.NativeLoader;
import com.pvsstudio.runner.PvsStudioAnalyzer;
import com.pvsstudio.utility.ProjectUtils;
import com.pvsstudio.warnings.SuppressBase;
import com.pvsstudio.warnings.SuppressBaseLoader;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningsSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.compiler.ModelBuildingException;

public class AnalyzerRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyzerRunner.class);
    @NotNull
    public final AnalyzerProgress progress;
    @NotNull
    private final WarningsSet warnings;
    @NotNull
    private final ExecutorService threadPool;
    @NotNull
    private final AnalyzerThreadFactory factory;
    private final AnnotationProcessor annotationProcessor;
    @Nullable
    private final CancellationChecker cancellationChecker;
    @Nullable
    private PvsStudioInvoker pvsStudioInvoker;

    @Inject
    public AnalyzerRunner(@NotNull AnalyzerProgress progress, @NotNull AnalyzerConfig config, @NotNull AnalyzerThreadFactory factory, AnnotationProcessor annotationProcessor) {
        this.progress = progress;
        this.annotationProcessor = annotationProcessor;
        this.factory = factory;
        if (config.writeToStdout.booleanValue()) {
            this.cancellationChecker = new CancellationChecker(this.progress);
            this.cancellationChecker.start();
            this.warnings = new WarningsSet(this.progress::printAsRawJson);
        } else {
            this.cancellationChecker = null;
            this.warnings = WarningsSet.createNew();
        }
        this.threadPool = Executors.newFixedThreadPool(config.threadsNum, factory);
        Thread moduleWorkerThread = Thread.currentThread();
        this.progress.onCancellation(() -> {
            moduleWorkerThread.interrupt();
            if (this.cancellationChecker != null) {
                this.cancellationChecker.interrupt();
            }
            this.threadPool.shutdownNow();
            if (this.pvsStudioInvoker != null) {
                this.pvsStudioInvoker.sendCancelToProcess();
            }
        });
    }

    public void setPvsStudioInvoker(@NotNull PvsStudioInvoker pvsStudioInvoker) {
        this.pvsStudioInvoker = pvsStudioInvoker;
    }

    protected boolean needCheckNativeLibrariesLoadedCorrected() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull Project project) {
        project.getModules().stream().filter(m -> project.getConfig().skipModules.contains(m.getName())).forEach(m -> project.getUniqueFiles().removeAll(m.getSourceFilesForAnalysis()));
        project.getModules().removeIf(m -> m.getSourceFilesForAnalysis().isEmpty() || project.getConfig().skipModules.contains(m.getName()));
        project.getModules().sort(Comparator.comparingInt(m -> m.getSourceFilesForAnalysis().size()).reversed());
        AnalyzerConfig config = project.getConfig();
        SuppressBaseLoader suppressBaseLoader = new SuppressBaseLoader(new File(config.suppressBase), true);
        SuppressBase suppressBase = null;
        try {
            suppressBase = suppressBaseLoader.load();
            if (suppressBase == null) {
                suppressBaseLoader.getSuppressBaseInvalidMessage();
            }
        }
        catch (JsonParseException jsonParseException) {
            System.err.println(suppressBaseLoader.getSuppressBaseInvalidMessage());
            this.progress.handleException(jsonParseException);
        }
        catch (IOException ioException) {
            this.progress.handleException(ioException);
        }
        if (suppressBase == null) {
            suppressBase = new SuppressBase();
        }
        boolean success = false;
        try {
            this.progress.startProject(project);
            try {
                ArrayList<ModuleModelBuilder.ModuleWorker> moduleWorkersWithBuildModels = new ArrayList<ModuleModelBuilder.ModuleWorker>();
                for (Module module : project.getModules()) {
                    this.progress.ensureNotCancelled();
                    ModuleModelBuilder.ModuleWorker moduleWorkerWithBuildModel = null;
                    try {
                        moduleWorkerWithBuildModel = new ModuleModelBuilder(this.progress.addModule(module), this.threadPool, module, this.warnings, suppressBase, this.annotationProcessor, this.needCheckNativeLibrariesLoadedCorrected()).createModuleWorkerWithBuiltModelAndAnalyzeTasksForModule();
                    }
                    catch (PvsStudioBuildException e) {
                        Warning warning;
                        String moduleName = module.getName();
                        if (config.launchMode == AnalyzerConfig.LaunchMode.CORE && e.getCause() instanceof ModelBuildingException) {
                            String pluginName;
                            ProjectUtils.ProjectType projectType = ProjectUtils.guessProjectType(config);
                            switch (projectType) {
                                case MAVEN: {
                                    pluginName = "PVS-Studio Maven plugin";
                                    break;
                                }
                                case GRADLE: {
                                    pluginName = "PVS-Studio Gradle plugin";
                                    break;
                                }
                                case UNKNOWN: {
                                    pluginName = "PVS-Studio plugin";
                                    break;
                                }
                                default: {
                                    pluginName = null;
                                }
                            }
                            warning = Warning.modelBuildFailedCliMessage(pluginName);
                        } else {
                            warning = Warning.modelBuildFailedMessage(moduleName);
                        }
                        warning = warning.addStacktrace(e);
                        if (config.loggingIsEnabled() && config.debugLog != null) {
                            warning.message = warning.message + String.format(" Detailed logs are located at '%s'.", config.debugLog);
                        }
                        this.getWarnings().add(warning);
                        LOG.error("Unable to start the analysis on {} module. {}.", new Object[]{moduleName, e.getMessage(), e});
                    }
                    if (moduleWorkerWithBuildModel == null) continue;
                    moduleWorkersWithBuildModels.add(moduleWorkerWithBuildModel);
                }
                NativeLoader.load();
                for (ModuleModelBuilder.ModuleWorker moduleWorkerWithBuildModel : moduleWorkersWithBuildModels) {
                    this.progress.ensureNotCancelled();
                    moduleWorkerWithBuildModel.runClassesAnalysisTasksFromModule();
                }
            }
            finally {
                this.threadPool.shutdown();
                if (this.cancellationChecker != null) {
                    this.cancellationChecker.interrupt();
                }
            }
            this.progress.ensureNotCancelled();
            success = true;
        }
        finally {
            this.aggregateResultsFromThreads(this.factory);
            if (success && !this.progress.hasAnythingToAnalyze()) {
                this.warnings.add(Warning.NO_SOURCES_FOUND);
            }
        }
    }

    private void aggregateResultsFromThreads(@NotNull AnalyzerThreadFactory factory) {
        long memory = 0L;
        for (PvsStudioAnalyzer analyzer : factory.getAnalyzers()) {
            if (Benchmark.isActive()) {
                memory += analyzer.getDataFlow().capacity();
            }
            this.warnings.addAll(analyzer.getWarnings());
        }
        Benchmark.instance().memory("Data flow (native)", memory);
    }

    @NotNull
    public WarningsSet getWarnings() {
        return this.warnings;
    }
}

