/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.runner;

import com.pvsstudio.projects.Module;
import com.pvsstudio.projects.Project;
import com.pvsstudio.runner.AnalysisCancelledException;
import com.pvsstudio.runner.StdOutProgress;
import com.pvsstudio.warnings.Warning;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public abstract class AnalyzerProgress {
    private static AnalyzerProgress instance;
    private final AtomicLong totalSources = new AtomicLong();
    private final List<ModuleProgress> modules = new ArrayList<ModuleProgress>();
    private final Object cancelledLock = new Object();
    private volatile boolean cancelled = false;
    private Runnable cancellationListener = null;

    public static synchronized AnalyzerProgress getInstance() {
        if (instance == null) {
            instance = new StdOutProgress();
        }
        return instance;
    }

    public abstract void progressModule(long var1, @NotNull String var3);

    public abstract void progressClass(long var1, @NotNull String var3);

    public abstract void printAsRawJson(@NotNull Warning var1);

    public abstract void handleException(@NotNull Throwable var1, @NotNull String var2, boolean var3);

    public final void handleException(@NotNull Throwable exception) {
        this.handleException(exception, "", true);
    }

    public final void handleException(@NotNull Throwable exception, @NotNull String position) {
        this.handleException(exception, position, true);
    }

    public void startProject(@NotNull Project project) {
        this.totalSources.set(project.getUniqueFiles().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ModuleProgress addModule(@NotNull Module module) {
        ModuleProgress progress = new ModuleProgress(module);
        List<ModuleProgress> list = this.modules;
        synchronized (list) {
            this.modules.add(progress);
        }
        return progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPercents() {
        List<ModuleProgress> list = this.modules;
        synchronized (list) {
            long totalProgress = this.modules.stream().mapToLong(ModuleProgress::getProgressCount).sum();
            return (long)(100.0 * (double)totalProgress / (double)this.totalSources.get());
        }
    }

    public final void onCancellation(Runnable listener) {
        this.cancellationListener = listener;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.cancelledLock;
        synchronized (object) {
            Runnable listener;
            boolean oldValue = this.cancelled;
            this.cancelled = true;
            if (!oldValue && (listener = this.cancellationListener) != null) {
                listener.run();
            }
        }
    }

    public void ensureNotCancelled() {
        if (this.isCancelled() || Thread.currentThread().isInterrupted()) {
            this.cancel();
            throw new AnalysisCancelledException();
        }
    }

    public boolean hasAnythingToAnalyze() {
        return this.totalSources.get() > 0L;
    }

    public final class ModuleProgress {
        private final Module module;
        private final long sources;
        private final AtomicLong startedClasses = new AtomicLong();
        private volatile boolean isFinished = false;

        private ModuleProgress(Module module) {
            this.module = module;
            this.sources = module.getSourceFilesForAnalysis().size();
        }

        public void startBuild() {
            AnalyzerProgress.this.progressModule(AnalyzerProgress.this.getPercents(), this.module.getName());
        }

        public void finishBuild() {
        }

        public void start() {
        }

        public void finish() {
            this.isFinished = true;
        }

        public void startClass(@NotNull String name) {
            this.startedClasses.incrementAndGet();
            AnalyzerProgress.this.progressClass(AnalyzerProgress.this.getPercents(), name);
        }

        public void finishClass() {
        }

        public long getProgressCount() {
            if (this.isFinished) {
                return this.sources;
            }
            return Math.min(this.sources, this.startedClasses.get());
        }

        @NotNull
        public AnalyzerProgress getProgress() {
            return AnalyzerProgress.this;
        }
    }
}

