/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.projects.Module;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.NavigationInfo;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningLevel;
import com.pvsstudio.warnings.WarningPosition;
import java.io.File;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;

public class WarningAdapter {
    private final Warning warning;
    public static final WarningAdapter INVALID_WARNING = new WarningAdapter();

    private WarningAdapter() {
        this.warning = new Warning();
    }

    public WarningAdapter(@NotNull Warning warning) {
        this.warning = warning;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof WarningAdapter)) {
            return false;
        }
        WarningAdapter warningAdapter = (WarningAdapter)other;
        return this.warning.equals(warningAdapter.warning);
    }

    public int hashCode() {
        return 13 * this.warning.hashCode();
    }

    public Optional<Integer> getCode() {
        return this.warning.getCode();
    }

    public WarningAdapter addSuffix(@NotNull String suffix) {
        if (this != INVALID_WARNING) {
            this.warning.addSuffix(suffix);
        }
        return this;
    }

    public WarningAdapter addSourcePosition(@Nullable CtElement from, @Nullable CtElement to, @NotNull Module module) {
        if (this != INVALID_WARNING && from != null && to != null) {
            SourcePosition fromPosition = from.getPosition();
            SourcePosition toPosition = to.getPosition();
            if (fromPosition.isValidPosition() && toPosition.isValidPosition() && fromPosition.getFile().equals(toPosition.getFile())) {
                File fromPositionFile = fromPosition.getFile();
                int fromPositionLine = fromPosition.getLine();
                WarningPosition position = new WarningPosition(fromPositionFile.getAbsolutePath(), fromPositionLine, toPosition.getEndLine(), fromPosition.getColumn(), toPosition.getEndColumn(), new NavigationInfo(module.getLine(fromPositionFile, fromPositionLine - 1).orElse(""), module.getLine(fromPositionFile, fromPositionLine).orElse(""), module.getLine(fromPositionFile, fromPositionLine + 1).orElse("")));
                this.warning.addSourcePosition(position);
            }
        }
        return this;
    }

    public WarningAdapter addSourcePosition(@Nullable CtElement element, @NotNull Module module) {
        if (this != INVALID_WARNING) {
            this.warning.addSourcePosition(RulesUtils.getPosition(element, module));
        }
        return this;
    }

    public WarningAdapter addSourcePositions(@NotNull Iterable<? extends CtElement> positions, @NotNull Module module) {
        if (this != INVALID_WARNING) {
            this.warning.addSourcePositions(RulesUtils.getPositions(positions, module));
        }
        return this;
    }

    public WarningAdapter setLevel(WarningLevel l) {
        if (this != INVALID_WARNING) {
            this.warning.setLevel(l);
        }
        return this;
    }

    public WarningAdapter setCwe(int value) {
        if (this != INVALID_WARNING) {
            this.warning.setCwe(value);
        }
        return this;
    }

    public WarningAdapter setSastId(String value) {
        if (this != INVALID_WARNING) {
            this.warning.setSastId(value);
        }
        return this;
    }

    @Nullable
    Warning getWarning() {
        return this.warning;
    }
}

