/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.io.File;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;

public class V6132
extends PvsStudioRule {
    private final PvsStudioRule.Pattern ruleExpression = new PvsStudioRule.PatternBuilder().setLevel(WarningLevel.LEVEL_1).setCwe(691).setMessage("It is possible that 'else' block was forgotten or commented out, thus altering the program's operation logics.").build();

    public void visitCtIf(CtIf ifElement) {
        Optional<String> sourceFileLine;
        File analyzedFile = ifElement.getPosition().getFile();
        CtStatement thenStatement = ifElement.getThenStatement();
        if (thenStatement == null) {
            return;
        }
        int thenStatementEndLine = thenStatement.getPosition().getEndLine();
        CtStatement elseStatement = ifElement.getElseStatement();
        if (elseStatement == null) {
            return;
        }
        int elseStatementLine = elseStatement.getPosition().getLine();
        boolean hasCommentWithoutCode = false;
        int elseLine = -1;
        for (int i = elseStatementLine; i >= thenStatementEndLine; --i) {
            Optional<String> sourceFileSearchLine = this.getModule().getLine(analyzedFile, i);
            if (sourceFileSearchLine.isEmpty()) continue;
            String currentLine = sourceFileSearchLine.get();
            if (i == elseStatementLine) {
                currentLine = currentLine.substring(0, elseStatement.getPosition().getColumn() - 1);
            }
            if (currentLine.contains("else")) {
                elseLine = i;
                break;
            }
            if (!currentLine.matches("\\s*//.*") || StringUtils.containsAny((CharSequence)currentLine, (char[])new char[]{';', '(', '{', '='})) continue;
            hasCommentWithoutCode = true;
        }
        if ((sourceFileLine = this.getModule().getLine(analyzedFile, elseStatementLine)).isEmpty()) {
            return;
        }
        if (sourceFileLine.get().matches("^\\s*[{]")) {
            return;
        }
        if (elseStatementLine - elseLine <= 1) {
            return;
        }
        if (hasCommentWithoutCode) {
            return;
        }
        int statementSpaceCount = this.getAmountOfSpaces(sourceFileLine.get().toCharArray());
        int statementTabCount = this.getAmountOfTabs(sourceFileLine.get().toCharArray());
        sourceFileLine = this.getModule().getLine(analyzedFile, elseLine);
        if (sourceFileLine.isEmpty()) {
            return;
        }
        int elseSpaceCount = this.getAmountOfSpaces(sourceFileLine.get().toCharArray());
        int elseTabCount = this.getAmountOfTabs(sourceFileLine.get().toCharArray());
        if (statementSpaceCount != elseSpaceCount || statementTabCount != elseTabCount) {
            return;
        }
        this.ruleExpression.add((CtElement)elseStatement, new Object[0]);
    }

    int getAmountOfSpaces(char[] chars) {
        int spaceCount = 0;
        for (char symbol : chars) {
            if (symbol == '\t') continue;
            if (symbol != ' ') break;
            ++spaceCount;
        }
        return spaceCount;
    }

    int getAmountOfTabs(char[] chars) {
        int tabCount = 0;
        for (char symbol : chars) {
            if (symbol == ' ') continue;
            if (symbol != '\t') break;
            ++tabCount;
        }
        return tabCount;
    }
}

