/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.core.Value;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6131
extends PvsStudioRule {
    private static final Set<BinaryOperatorKind> ARITHMETIC_BINARY_OPERATOR_KINDS = EnumSet.of(BinaryOperatorKind.PLUS, BinaryOperatorKind.MINUS, BinaryOperatorKind.MUL, BinaryOperatorKind.DIV, BinaryOperatorKind.MOD);
    private static final Set<BinaryOperatorKind> BIT_SHIFT_BINARY_OPERATOR_KINDS = EnumSet.of(BinaryOperatorKind.SL, BinaryOperatorKind.SR, BinaryOperatorKind.USR);
    private static final Map<String, IntegerVirtualValue> RANGE_BY_TYPENAME = Map.of(Byte.TYPE.getName(), IntegerVirtualValue.fromMinMax(-128L, 255L), Short.TYPE.getName(), IntegerVirtualValue.fromMinMax(-32768L, 32767L), Character.TYPE.getName(), IntegerVirtualValue.fromMinMax(0L, 65535L), Integer.TYPE.getName(), IntegerVirtualValue.fromMinMax(Integer.MIN_VALUE, Integer.MAX_VALUE), Long.TYPE.getName(), IntegerVirtualValue.fromMinMax(Long.MIN_VALUE, Long.MAX_VALUE));
    private final PvsStudioRule.Pattern ruleExpression = this.defaultPatternBuilder().setMessage("Casting a result of the expression to a type with a smaller range will result in an overflow.").setExtendedMessage("Casting a result of the expression '%s' to a type with a smaller range will result in an overflow.").build();
    private final PvsStudioRule.Pattern ruleVariable = this.defaultPatternBuilder().setMessage("Casting the variable to a type with a smaller range will result in an overflow.").setExtendedMessage("Casting the '%s' variable to a type with a smaller range will result in an overflow.").build();
    private final PvsStudioRule.Pattern ruleField = this.defaultPatternBuilder().setMessage("Casting the field to a type with a smaller range will result in an overflow.").setExtendedMessage("Casting the '%s' field to a type with a smaller range will result in an overflow.").build();

    private PvsStudioRule.PatternBuilder defaultPatternBuilder() {
        return new PvsStudioRule.PatternBuilder().setCwe(190).setSecId("SEC-OVERFLOW-OR-INT-UINT").setSastId("CERT-NUM00-J").setLevel(WarningLevel.LEVEL_2);
    }

    public <T> void visitCtBinaryOperator(@NotNull CtBinaryOperator<T> operator) {
        if (!ARITHMETIC_BINARY_OPERATOR_KINDS.contains(operator.getKind())) {
            return;
        }
        this.visitExpression((CtExpression<?>)operator);
    }

    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(@NotNull CtExecutableReferenceExpression<T, E> expression) {
        this.visitExpression((CtExpression<?>)expression);
    }

    public <T> void visitCtConditional(@NotNull CtConditional<T> conditional) {
        this.visitExpression((CtExpression<?>)conditional);
    }

    public <T> void visitCtVariableRead(@NotNull CtVariableRead<T> variableRead) {
        this.visitExpression((CtExpression<?>)variableRead);
    }

    public <T> void visitCtVariableWrite(@NotNull CtVariableWrite<T> variableWrite) {
        this.visitExpression((CtExpression<?>)variableWrite);
    }

    public <T> void visitCtFieldRead(@NotNull CtFieldRead<T> fieldRead) {
        this.visitExpression((CtExpression<?>)fieldRead);
    }

    public <T> void visitCtFieldWrite(@NotNull CtFieldWrite<T> fieldWrite) {
        this.visitExpression((CtExpression<?>)fieldWrite);
    }

    public <T> void visitCtArrayRead(@NotNull CtArrayRead<T> arrayRead) {
        this.visitExpression((CtExpression<?>)arrayRead);
    }

    public <T> void visitCtArrayWrite(@NotNull CtArrayWrite<T> arrayWrite) {
        this.visitExpression((CtExpression<?>)arrayWrite);
    }

    public <T> void visitCtUnaryOperator(@NotNull CtUnaryOperator<T> operator) {
        this.visitExpression((CtExpression<?>)operator);
    }

    public <T, A extends T> void visitCtOperatorAssignment(@NotNull CtOperatorAssignment<T, A> assignment) {
        this.visitExpression((CtExpression<?>)assignment);
    }

    @Override
    public <T> void visitCtInvocation(@NotNull CtInvocation<T> invocation) {
        this.visitExpression((CtExpression<?>)invocation);
    }

    private void visitExpression(@NotNull CtExpression<?> expression) {
        if (this.isInsideTestSources((CtElement)expression)) {
            return;
        }
        if (this.isBitShiftWritePart(expression)) {
            return;
        }
        PvsStudioRule.Pattern rule = this.ruleFor(expression);
        List<Pair<String, Value>> valuesWithTargetTypes = this.getDataFlow().getValuesWithTargetTypesBeforeCasts((CtElement)expression);
        for (Pair<String, Value> valueWithTargetType : valuesWithTargetTypes) {
            IntegerVirtualValue virtualValue;
            String typename = (String)valueWithTargetType.getKey();
            Value value = (Value)valueWithTargetType.getValue();
            IntegerVirtualValue typeRange = RANGE_BY_TYPENAME.get(typename);
            if (typeRange == null || (virtualValue = value.toInteger()) == null || !virtualValue.isPrecise() || expression instanceof CtInvocation && V6131.isRandomInvocation((CtInvocation)expression) || virtualValue.isInInterval(typeRange.min(), typeRange.max())) continue;
            rule.add((CtElement)expression, V6131.withoutTypeCasts(expression));
            break;
        }
    }

    @NotNull
    private PvsStudioRule.Pattern ruleFor(@NotNull CtExpression<?> expression) {
        if (expression instanceof CtFieldRead) {
            return this.ruleField;
        }
        if (expression instanceof CtVariableRead) {
            return this.ruleVariable;
        }
        return this.ruleExpression;
    }

    @NotNull
    private static CtExpression<?> withoutTypeCasts(@NotNull CtExpression<?> expression) {
        CtExpression clone = expression.clone();
        clone.setTypeCasts(List.of());
        return clone;
    }

    private boolean isBitShiftWritePart(@NotNull CtExpression<?> expression) {
        List casts = expression.getTypeCasts();
        if (casts.size() != 1 || !"byte".equals(((CtTypeReference)casts.get(0)).toString())) {
            return false;
        }
        Optional<CtVariableAccess<?>> optionalVariableReference = V6131.findSingleVariableReferenceOrNothing(expression);
        if (optionalVariableReference.isEmpty()) {
            return false;
        }
        CtVariableAccess<?> expressionVariable = optionalVariableReference.get();
        DataFlow dataFlow = this.getJavaDataFlow();
        if (dataFlow == null) {
            return false;
        }
        CtStatement statement = (CtStatement)expression.getParent(CtStatement.class);
        if (statement == null) {
            return false;
        }
        List<CtBinaryOperator<?>> binaryOperators = V6131.listBinaryOperatorsChildren(dataFlow.getVariableUsageChainWithElement(expressionVariable, (CtElement)statement));
        for (CtBinaryOperator<?> binaryOperator : binaryOperators) {
            CtVariableRead variableRead;
            CtVariableReference operatorVariable;
            CtExpression leftHandOperand;
            if (!BIT_SHIFT_BINARY_OPERATOR_KINDS.contains(binaryOperator.getKind()) || !((leftHandOperand = binaryOperator.getLeftHandOperand()) instanceof CtVariableRead) || !(operatorVariable = (variableRead = (CtVariableRead)leftHandOperand).getVariable()).equals((Object)expressionVariable.getVariable())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<CtBinaryOperator<?>> listBinaryOperatorsChildren(@NotNull Collection<CtElement> elements) {
        ArrayList result = new ArrayList();
        for (CtElement element : elements) {
            element.filterChildren((Filter)new TypeFilter(CtBinaryOperator.class)).forEach(result::add);
        }
        return result;
    }

    @NotNull
    private static Optional<CtVariableAccess<?>> findSingleVariableReferenceOrNothing(@NotNull CtElement element) {
        if (element instanceof CtVariableAccess) {
            return Optional.of((CtVariableAccess)element);
        }
        Iterator iterator = element.getDirectChildren().stream().filter(CtVariableAccess.class::isInstance).map(CtVariableAccess.class::cast).iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        CtVariableAccess candidate = (CtVariableAccess)iterator.next();
        return iterator.hasNext() ? Optional.empty() : Optional.of(candidate);
    }

    private static boolean isRandomInvocation(CtInvocation<?> invocation) {
        boolean flag = false;
        if (invocation.getTarget() != null && invocation.getTarget().getType() != null) {
            flag = invocation.getTarget().getType().getQualifiedName().toLowerCase().contains("random");
        }
        if (invocation.getExecutable() != null) {
            flag = flag || invocation.getExecutable().getSimpleName().toLowerCase().contains("random");
        }
        return flag;
    }
}

