/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtElement;

public class V6130
extends PvsStudioRule {
    PvsStudioRule.PatternBuilder builder = new PvsStudioRule.PatternBuilder(this).setLevel(WarningLevel.LEVEL_2).setCwe(190).setSastId("CERT-NUM00-J").setSecId("SEC-OVERFLOW-OR-INT-UINT");
    private final PvsStudioRule.Pattern rule = this.builder.setMessage("Integer overflow in the arithmetic expression '%s'. Left operand is '%s', right operand is '%s'.").build();
    private final PvsStudioRule.Pattern rulePossible = this.builder.setMessage("Possible integer overflow in the arithmetic expression '%s'. Left operand is '%s', right operand is '%s'.").build();
    private final PvsStudioRule.Pattern ruleShort = this.builder.setMessage("Integer overflow in the arithmetic expression '%s'.").build();

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        IntegerVirtualValue virtualValue;
        if (this.getCurrentMethod() != null && this.getCurrentMethod().getSimpleName().equals("hashCode")) {
            return;
        }
        if ((operator.getKind() == BinaryOperatorKind.PLUS || operator.getKind() == BinaryOperatorKind.MINUS || operator.getKind() == BinaryOperatorKind.MUL || operator.getKind() == BinaryOperatorKind.DIV || operator.getKind() == BinaryOperatorKind.MOD) && (virtualValue = this.getValue((CtElement)operator).toInteger()) != null && virtualValue.isOverflow()) {
            if (operator.getLeftHandOperand() instanceof CtLiteral && operator.getRightHandOperand() instanceof CtLiteral) {
                this.ruleShort.add((CtElement)operator, operator);
            } else if (virtualValue.isInterval()) {
                this.rulePossible.add((CtElement)operator, operator, this.getValue((CtElement)operator.getLeftHandOperand()), this.getValue((CtElement)operator.getRightHandOperand()));
            } else {
                this.rule.add((CtElement)operator, operator, this.getValue((CtElement)operator.getLeftHandOperand()), this.getValue((CtElement)operator.getRightHandOperand()));
            }
        }
    }
}

