/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.visitor.CtScanner;

public class V6129
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Possible deadlock due to incorrect synchronization order between locks.").setLevel(WarningLevel.LEVEL_1).setCwe(833).setSastId("CERT-LCK07-J").setSecId("SEC-SYNCHRONIZATION").build();
    private final List<List<CtExpression<?>>> knownSynchronizedChains = new ArrayList();

    public <T> void visitCtClass(@NotNull CtClass<T> ctClass) {
        for (CtAnonymousExecutable executable : ctClass.getAnonymousExecutables()) {
            this.visitBlock(executable.getBody());
        }
        for (CtExecutableReference executableReference : ctClass.getDeclaredExecutables()) {
            CtExecutable declaration = executableReference.getDeclaration();
            if (declaration == null) continue;
            this.visitBlock(declaration.getBody());
        }
        this.knownSynchronizedChains.clear();
    }

    private void visitBlock(@Nullable CtBlock<?> block) {
        if (block == null) {
            return;
        }
        Collection<List<CtExpression<?>>> chains = V6129.listExpressionChains(block);
        for (List<CtExpression<?>> actualChain : chains) {
            List<CtExpression<?>> expectedChainOrder = this.findMostIntersectingKnownChainWith(actualChain);
            if (expectedChainOrder.isEmpty()) {
                this.knownSynchronizedChains.add(actualChain);
                continue;
            }
            int lastExpectedIndex = -1;
            for (CtExpression<?> actual : actualChain) {
                int expectedIndex = expectedChainOrder.indexOf(actual);
                if (expectedIndex == -1) continue;
                if (expectedIndex < lastExpectedIndex) {
                    this.rule.add((CtElement)actual, new Object[0]).addSourcePosition((CtElement)expectedChainOrder.get(expectedIndex), this.getModule());
                    return;
                }
                lastExpectedIndex = expectedIndex;
            }
            this.knownSynchronizedChains.add(actualChain);
        }
    }

    @NotNull
    private List<CtExpression<?>> findMostIntersectingKnownChainWith(@NotNull List<CtExpression<?>> chain) {
        List mostIntersectingKnownChain = this.knownSynchronizedChains.stream().max(Comparator.comparingLong(candidate -> candidate.stream().filter(chain::contains).count())).orElseGet(List::of);
        if (mostIntersectingKnownChain.stream().noneMatch(chain::contains)) {
            return List.of();
        }
        return mostIntersectingKnownChain;
    }

    @NotNull
    private static Collection<List<CtExpression<?>>> listExpressionChains(@NotNull CtElement root) {
        SynchronizedChainsBuilder chainsBuilder = new SynchronizedChainsBuilder();
        chainsBuilder.scan(root);
        return chainsBuilder.listChains();
    }

    private static final class SynchronizedChainsBuilder
    extends CtScanner {
        private final List<List<CtExpression<?>>> chains = new ArrayList();
        private final Deque<List<CtExpression<?>>> chainStack = new LinkedList();

        private SynchronizedChainsBuilder() {
        }

        public void visitCtSynchronized(@NotNull CtSynchronized synchro) {
            ArrayList<CtExpression> currentChain = this.chainStack.isEmpty() ? new ArrayList<CtExpression>(1) : new ArrayList(this.chainStack.peek());
            currentChain.add(synchro.getExpression());
            this.chainStack.push(currentChain);
            int beforeCount = this.chains.size();
            super.visitCtSynchronized(synchro);
            int afterCount = this.chains.size();
            if (currentChain.size() >= 2 && afterCount == beforeCount) {
                this.chains.add(currentChain);
            }
            this.chainStack.pop();
        }

        @NotNull
        private List<List<CtExpression<?>>> listChains() {
            return this.chains;
        }
    }
}

