/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtResource;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtVariableReference;

public class V6128
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("The use of a 'Closable' object after it has been closed can lead to an exception.").setCwe(672).setSecId("SEC-MEMORY").setLevel(WarningLevel.LEVEL_2).build();
    private final Map<CtMethod<?>, List<Usage>> warnings = new IdentityHashMap();

    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        if (this.isInsideTestSources((CtElement)tryWithResource)) {
            return;
        }
        if (this.getDataFlow().isUnreachable()) {
            return;
        }
        CtMethod method = (CtMethod)tryWithResource.getParent(CtMethod.class);
        if (method == null) {
            return;
        }
        DataFlow dataflow = this.getJavaDataFlow();
        if (dataflow == null) {
            return;
        }
        List resources = tryWithResource.getResources();
        for (CtResource resource : resources) {
            if (!(resource instanceof CtVariable)) continue;
            CtVariable resourceVariable = (CtVariable)resource;
            List<CtElement> usages = dataflow.getReachableUsages((CtElement)resourceVariable.getReference(), this::filterToInvocations);
            CtBlock block = tryWithResource.getBody();
            List<CtElement> usagesOutsideOfTry = usages.stream().filter(usage -> !usage.hasParent((CtElement)block)).collect(Collectors.toList());
            if (usagesOutsideOfTry.isEmpty()) continue;
            this.saveWarning((CtElement)tryWithResource, usagesOutsideOfTry);
        }
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        if (this.isInsideTestSources((CtElement)inv)) {
            return;
        }
        if (this.getDataFlow().isUnreachable()) {
            List<Usage> possibleWarnings = this.warnings.get(inv.getParent(CtMethod.class));
            if (possibleWarnings == null) {
                return;
            }
            Optional<Usage> deadUsage = possibleWarnings.stream().filter(element -> element.getUsages().contains(inv)).findFirst();
            if (deadUsage.isEmpty()) {
                return;
            }
            Usage dead = deadUsage.get();
            dead.getUsages().removeIf(element -> element.equals((Object)inv));
            if (dead.getUsages().isEmpty()) {
                possibleWarnings.remove(dead);
            }
            return;
        }
        if (!inv.getExecutable().getSimpleName().equals("close")) {
            return;
        }
        if (inv.getExecutable().getDeclaringType() == null) {
            return;
        }
        if (!inv.getExecutable().getDeclaringType().isSubtypeOf(inv.getFactory().Type().createReference(Closeable.class))) {
            return;
        }
        DataFlow dataflow = this.getJavaDataFlow();
        if (dataflow == null) {
            return;
        }
        CtExpression target = inv.getTarget();
        if (!(target instanceof CtVariableAccess)) {
            return;
        }
        CtVariableReference variable = ((CtVariableAccess)target).getVariable();
        CtVariable declaration = variable.getDeclaration();
        if (!(declaration instanceof CtLocalVariable) && !(declaration instanceof CtParameter)) {
            return;
        }
        CtMethod method = (CtMethod)inv.getParent(CtMethod.class);
        if (method == null) {
            return;
        }
        List<CtElement> reachableUsages = dataflow.getReachableUsages((CtElement)variable, this::filterToInvocations);
        if (!reachableUsages.isEmpty()) {
            this.saveWarning((CtElement)inv, reachableUsages);
        }
    }

    private boolean filterToInvocations(CtVariableReference<?> reference) {
        if (reference.getParent() instanceof CtVariableAccess && reference.getParent().getRoleInParent() == CtRole.TARGET) {
            CtInvocation invocation = (CtInvocation)reference.getParent(CtInvocation.class);
            if (invocation == null) {
                return false;
            }
            CtExecutableReference executable = invocation.getExecutable();
            if (executable == null) {
                return false;
            }
            return StringUtils.startsWithAny((CharSequence)executable.getSimpleName(), (CharSequence[])new CharSequence[]{"read", "available"});
        }
        return false;
    }

    private void saveWarning(CtElement position, List<CtElement> additional) {
        CtMethod method = (CtMethod)position.getParent(CtMethod.class);
        List methodWarnings = this.warnings.computeIfAbsent(method, ignore -> new ArrayList());
        methodWarnings.add(new Usage(position, additional));
    }

    @Override
    public void exit(CtElement e) {
        if (e instanceof CtMethod) {
            CtMethod method = (CtMethod)e;
            List<Usage> positions = this.warnings.get(method);
            if (positions == null) {
                return;
            }
            for (Usage position : positions) {
                if (position.getUsages().isEmpty()) continue;
                WarningAdapter warning = this.rule.add(position.getCloseStatement(), new Object[0]);
                position.getUsages().forEach(p -> warning.addSourcePosition((CtElement)p, this.getModule()));
                this.warnings.remove(method);
            }
        }
    }

    @Override
    public boolean isEnabledInUnreachableCode() {
        return true;
    }

    private static class Usage {
        private final CtElement closeStatement;
        private final List<CtElement> usages;

        public Usage(CtElement closeStatement, List<CtElement> usages) {
            this.closeStatement = closeStatement;
            this.usages = usages;
        }

        public CtElement getCloseStatement() {
            return this.closeStatement;
        }

        public List<CtElement> getUsages() {
            return this.usages;
        }
    }
}

