/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.dataflow.utility.InvocationWrapper;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.utility.closeable.CloseableFieldsAnalyzer;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.List;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;

public class V6127
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Closeable object is not closed. This may lead to a resource leak.").setExtendedMessage("The '%s' Closeable object is not closed. This may lead to a resource leak.").setCwe(772).setSastId("CERT-FIO04-J").setLevel(WarningLevel.LEVEL_2).setSecId("SEC-LEAKS").build();
    private static final List<String> NO_RESOURCE = List.of("java.io.StringReader", "java.io.StringWriter", "java.io.CharArrayReader", "java.io.CharArrayWriter", "java.io.ByteArrayInputStream", "java.io.ByteArrayOutputStream");

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> inv) {
        CtVariableReference<?> reference;
        if (!this.verifyInvocation(inv)) {
            return;
        }
        CtElement parent = inv.getParent();
        if (this.isConstructorInsideConstructor(parent)) {
            this.rule.add((CtElement)inv, inv);
        }
        if ((reference = this.getReferenceOfAssignment(parent)) == null) {
            return;
        }
        this.applyTargetStatement((CtStatement)parent, reference);
    }

    private void applyTargetStatement(CtStatement initStatement, CtVariableReference<?> variableReference) {
        DataFlow dataFlow = this.getJavaDataFlow();
        if (dataFlow == null) {
            return;
        }
        InvocationWrapper simpleClose = new InvocationWrapper("close", "void", new ArrayList<String>(), "");
        InvocationWrapper quietlyClose = new InvocationWrapper("closeQuietly", "void", new ArrayList<String>(), "");
        InvocationWrapper silentlyClose = new InvocationWrapper("closeSilently", "void", new ArrayList<String>(), "");
        InvocationWrapper closeStream = new InvocationWrapper("closeStream", "void", new ArrayList<String>(), "");
        List<InvocationWrapper> invWrapper = List.of(simpleClose);
        List<InvocationWrapper> invObjPassWrapper = List.of(quietlyClose, silentlyClose, closeStream);
        boolean result = dataFlow.methodCallsFromAllControlFlowPaths((CtMethod)this.getCurrentMethod(), initStatement, variableReference, invWrapper, invObjPassWrapper);
        if (!result) {
            this.rule.add((CtElement)initStatement, variableReference);
        }
    }

    private boolean verifyInvocation(CtConstructorCall<?> inv) {
        if (this.getDataFlow().isUnreachable()) {
            return false;
        }
        if (this.isInsideTestSources((CtElement)inv)) {
            return false;
        }
        if (!(this.getCurrentMethod() instanceof CtMethod)) {
            return false;
        }
        if (!this.isTargetType(inv.getType())) {
            return false;
        }
        CtElement parent = inv.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.getParent() instanceof CtTryWithResource) {
            return false;
        }
        if (inv.getType().getTypeDeclaration() == null) {
            return false;
        }
        for (CtExpression arg : inv.getArguments()) {
            if (!RulesUtils.implementsType(arg.getType(), "java.lang.AutoCloseable", true)) continue;
            return false;
        }
        if (inv.getType().getQualifiedName().equals("java.util.Formatter") && inv.getArguments().isEmpty()) {
            return false;
        }
        if (inv.getType().getQualifiedName().equals("java.util.Scanner") && inv.getArguments().size() == 1 && ((CtExpression)inv.getArguments().get(0)).getType().getQualifiedName().equals("java.lang.String")) {
            return false;
        }
        return !CloseableFieldsAnalyzer.isEmptyCloseMethod(inv.getType().getTypeDeclaration());
    }

    private CtVariableReference<?> getReferenceOfAssignment(CtElement element) {
        CtVariableReference reference = null;
        if (element instanceof CtLocalVariable) {
            reference = ((CtVariable)element).getReference();
        } else if (element instanceof CtAssignment) {
            CtAssignment parentAssignment = (CtAssignment)element;
            if (parentAssignment.getAssigned() instanceof CtFieldWrite) {
                return null;
            }
            if (parentAssignment.getAssigned() instanceof CtVariableAccess) {
                reference = ((CtVariableAccess)parentAssignment.getAssigned()).getVariable();
            }
        }
        return reference;
    }

    private boolean isConstructorInsideConstructor(CtElement element) {
        CtConstructorCall parentInv;
        return element instanceof CtConstructorCall && (parentInv = (CtConstructorCall)element).getExecutable().getExecutableDeclaration() instanceof CtConstructor && !parentInv.getExecutable().getExecutableDeclaration().getThrownTypes().isEmpty();
    }

    private boolean isTargetType(CtTypeReference<?> expression) {
        if (!RulesUtils.implementsType(expression, "java.lang.AutoCloseable", true)) {
            return false;
        }
        for (String type : NO_RESOURCE) {
            if (!RulesUtils.implementsType(expression, type, true)) continue;
            return false;
        }
        return true;
    }
}

