/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;

public class V6126
extends PvsStudioRule {
    private static final List<String> TARGET_TYPES = List.of(Lock.class.getName(), Condition.class.getName(), ReadWriteLock.class.getName(), StampedLock.class.getName());
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Intrinsic lock should not be used on instance of high-level concurrency class. Use high-level locking facilities provided by the class itself.").setLevel(WarningLevel.LEVEL_1).setCwe(821).setSastId("CERT-LCK03-J").setSecId("SEC-SYNCHRONIZATION").build();

    public void visitCtSynchronized(@NotNull CtSynchronized synchro) {
        CtTypeReference expressionType = synchro.getExpression().getType();
        if (this.isTargetTypeInheritor(expressionType)) {
            this.rule.add((CtElement)synchro, expressionType.getQualifiedName());
        }
    }

    private boolean isTargetTypeInheritor(@NotNull CtTypeReference<?> type) {
        return TARGET_TYPES.stream().anyMatch(targetType -> RulesUtils.implementsType(type, targetType, true));
    }
}

