/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtExecutableReference;

public class V6125
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("The %s method is called potentially outside of synchronized context. Such call will lead to IllegalMonitorStateException.").setCwe(821).setLevel(WarningLevel.LEVEL_2).setSecId("SEC-SYNCHRONIZATION").build();
    private static final List<String> TARGET_METHODS = List.of("wait", "notify", "notifyAll");
    private final List<CtInvocation<?>> visitedInvocations = new LinkedList();

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        this.visitedInvocations.clear();
        CtExecutableReference method = inv.getExecutable();
        if (TARGET_METHODS.contains(method.getSimpleName()) && method.getDeclaringType().getSimpleName().equals("Object") && !this.methodCallsOnlyFromSynchronizedContext(inv)) {
            this.rule.add((CtElement)inv, method.getSimpleName());
        }
    }

    private boolean methodCallsOnlyFromSynchronizedContext(CtInvocation<?> inv) {
        if (inv.getParent(CtSynchronized.class) != null) {
            return true;
        }
        CtMethod methodExecutor = (CtMethod)inv.getParent(CtMethod.class);
        if (methodExecutor == null) {
            return true;
        }
        if (methodExecutor.getModifiers().contains(ModifierKind.SYNCHRONIZED)) {
            return true;
        }
        if (methodExecutor.getModifiers().contains(ModifierKind.PUBLIC)) {
            return false;
        }
        if (this.visitedInvocations.contains(inv)) {
            return true;
        }
        this.visitedInvocations.add(inv);
        List invocations = ((CtClass)inv.getParent(CtClass.class)).getElements(CtInvocation.class::isInstance);
        invocations = invocations.stream().filter(invoc -> ((CtClass)invoc.getParent(CtClass.class)).isPublic()).collect(Collectors.toList());
        List targetInvocations = invocations.stream().filter(i -> i.getExecutable().getExecutableDeclaration().equals((Object)methodExecutor)).collect(Collectors.toList());
        return targetInvocations.stream().allMatch(this::methodCallsOnlyFromSynchronizedContext);
    }
}

