/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtRHSReceiver;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;

public class V6124
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Converting an integer literal to the type with a smaller value range will result in overflow.").setLevel(WarningLevel.LEVEL_1).setCwe(681).setCwe(197).setSastId("CERT-NUM12-J").setSecId("SEC-OVERFLOW-OR-INT-UINT").build();
    private static final Map<List<String>, Pair<Integer, Integer>> TYPE_SIZE = Map.of(Arrays.asList("char", "Character"), Pair.of((Object)0, (Object)65535), Arrays.asList("byte", "Byte"), Pair.of((Object)-128, (Object)255), Arrays.asList("short", "Short"), Pair.of((Object)Short.MIN_VALUE, (Object)Short.MAX_VALUE), Arrays.asList("int", "Integer"), Pair.of((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE));

    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
        String type = Optional.of(assignment.getAssigned()).map(CtTypedElement::getType).map(CtTypeReference::getSimpleName).orElse("");
        if (!this.isTargetType(type) || this.isInsideTestSources((CtElement)assignment)) {
            return;
        }
        this.handleInputStatement((CtRHSReceiver<?>)assignment);
    }

    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        if (!this.isTargetType(localVariable.getType().getSimpleName()) || this.isInsideTestSources((CtElement)localVariable)) {
            return;
        }
        this.handleInputStatement((CtRHSReceiver<?>)localVariable);
    }

    private void handleInputStatement(CtRHSReceiver<?> inputValue) {
        if (inputValue.getAssignment() != null && !inputValue.getAssignment().getTypeCasts().isEmpty()) {
            Optional<Number> currentExpression;
            String type = ((CtTypeReference)inputValue.getAssignment().getTypeCasts().get(0)).getSimpleName();
            if (!this.isTargetType(type)) {
                return;
            }
            Optional<Number> optional = currentExpression = inputValue.getAssignment() instanceof CtUnaryOperator ? this.getTargetValueFromUnaryOperators(inputValue.getAssignment()) : this.getTargetValue(inputValue.getAssignment());
            if (currentExpression.isPresent() && this.outOfRange(currentExpression.get(), type)) {
                this.rule.add((CtElement)inputValue, inputValue);
            }
        }
    }

    private Optional<Number> getTargetValue(CtExpression<?> expression) {
        Optional<Number> result = Optional.empty();
        if (expression instanceof CtLiteral) {
            Object targetExpression = expression.getValueByRole(CtRole.VALUE);
            if (targetExpression instanceof Character) {
                result = Optional.of(Integer.valueOf(((Character)targetExpression).charValue()));
            } else if (targetExpression instanceof Number) {
                result = Optional.of((Number)expression.getValueByRole(CtRole.VALUE));
            }
        }
        return result;
    }

    private Optional<Number> getTargetValueFromUnaryOperators(CtExpression<?> expression) {
        CtUnaryOperator unaryOperator;
        Optional<Number> currentExpression = this.getTargetValue(expression);
        if (currentExpression.isPresent()) {
            return currentExpression;
        }
        if (expression instanceof CtUnaryOperator && (currentExpression = this.getTargetValueFromUnaryOperators((unaryOperator = (CtUnaryOperator)expression).getOperand())).isPresent()) {
            switch (unaryOperator.getKind()) {
                case NEG: {
                    currentExpression = Optional.of(-currentExpression.get().longValue());
                    break;
                }
                case POS: {
                    break;
                }
                default: {
                    currentExpression = Optional.empty();
                }
            }
        }
        return currentExpression;
    }

    private boolean isTargetType(String type) {
        for (List<String> types : TYPE_SIZE.keySet()) {
            if (!types.contains(type)) continue;
            return true;
        }
        return false;
    }

    private boolean outOfRange(Number number, String type) {
        Pair<Integer, Integer> range = null;
        for (List<String> types : TYPE_SIZE.keySet()) {
            if (!types.contains(type)) continue;
            range = TYPE_SIZE.get(types);
        }
        return range != null && (number.longValue() < ((Integer)range.getLeft()).longValue() || number.longValue() > ((Integer)range.getRight()).longValue());
    }
}

