/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.AbstractFilter;

public class V6123
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Modified value of the operand is not used after the %s operation.").setLevel(WarningLevel.LEVEL_2).setCwe(563).build();
    private static final int USAGE_THRESHOLD = 3;

    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        if (this.isInsideTestSources((CtElement)operator)) {
            return;
        }
        UnaryOperatorKind kind = operator.getKind();
        if (!this.isUnaryDecrementOrIncrement(kind)) {
            return;
        }
        CtRole role = operator.getRoleInParent();
        if (role == CtRole.STATEMENT) {
            return;
        }
        Function<CtUnaryOperator<?>, Boolean> filter = op -> Optional.of(op).filter(u -> u.getRoleInParent() == role).isPresent();
        CtElement parent = operator.getParent();
        if (parent instanceof CtArrayAccess) {
            filter = op -> Optional.of(op).filter(o -> o.getParent() instanceof CtArrayAccess).isPresent();
        }
        if (parent instanceof CtReturn || parent instanceof CtLambda) {
            filter = null;
        }
        this.apply(operator, filter);
    }

    public void apply(@NotNull CtUnaryOperator<?> operator, @Nullable Function<CtUnaryOperator<?>, Boolean> kindFilter) {
        if (!(operator.getOperand() instanceof CtVariableAccess) || operator.getOperand() instanceof CtFieldAccess) {
            return;
        }
        CtExecutable executable = (CtExecutable)operator.getParent(CtExecutable.class);
        if (executable == null) {
            return;
        }
        if (kindFilter == null) {
            this.addRule(operator);
            return;
        }
        if (operator.getParent(CtLoop.class) != null) {
            return;
        }
        CtVariableAccess variableAccess = (CtVariableAccess)operator.getOperand();
        final CtVariableReference variableReference = variableAccess.getVariable();
        ArrayList variableUsages = new ArrayList(executable.getElements((Filter)new AbstractFilter<CtVariableAccess<?>>(CtVariableAccess.class){

            public boolean matches(CtVariableAccess<?> access) {
                return access.getVariable().equals((Object)variableReference);
            }
        }));
        if (variableUsages.size() < 2) {
            this.addRule(operator);
            return;
        }
        if (variableUsages.get(variableUsages.size() - 1) == variableAccess) {
            long numberOfUsages = variableUsages.stream().map(CtElement::getParent).filter(CtUnaryOperator.class::isInstance).map(CtUnaryOperator.class::cast).filter(unary -> this.isUnaryDecrementOrIncrement(unary.getKind())).filter(kindFilter::apply).count();
            if (numberOfUsages < 3L) {
                this.addRule(operator);
            }
        }
    }

    public void addRule(CtUnaryOperator<?> operator) {
        String stringKind = this.unaryKindToString(operator.getKind());
        this.rule.add((CtElement)operator, stringKind);
    }

    private String unaryKindToString(UnaryOperatorKind kind) {
        switch (kind) {
            case POSTINC: {
                return "increment";
            }
            case POSTDEC: {
                return "decrement";
            }
        }
        return "";
    }

    private boolean isUnaryDecrementOrIncrement(UnaryOperatorKind kind) {
        return kind == UnaryOperatorKind.POSTINC || kind == UnaryOperatorKind.POSTDEC;
    }
}

