/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.support.reflect.code.CtLiteralImpl;

public class V6122
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Usage of 'Y' (week year) pattern was detected: it was probably intended to use 'y' (year).").setLevel(WarningLevel.LEVEL_1).build();
    private static final Set<String> TARGET_CLASSES = new HashSet<String>();
    private static final Pattern PATTERN_EXCEPTION;

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> inv) {
        if (inv.getExecutable() != null && TARGET_CLASSES.contains(inv.getExecutable().getDeclaringType().getSimpleName())) {
            this.handleMatchInvocation((CtAbstractInvocation<?>)inv);
        }
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        if (inv.getExecutable() != null && inv.getExecutable().getType() != null && TARGET_CLASSES.contains(inv.getExecutable().getType().getSimpleName()) && inv.getExecutable().getSimpleName().equals("ofPattern")) {
            this.handleMatchInvocation((CtAbstractInvocation<?>)inv);
        }
    }

    private void handleMatchInvocation(CtAbstractInvocation<?> inv) {
        if (inv.getArguments().isEmpty()) {
            return;
        }
        CtExpression parameter = (CtExpression)inv.getArguments().get(0);
        if (parameter instanceof CtLiteralImpl && this.datePatternIsIncorrect(parameter.toString())) {
            this.rule.add((CtElement)parameter, parameter);
        }
    }

    private boolean datePatternIsIncorrect(String date) {
        return (date = date.replaceAll("\"", "")).contains("Y") && !date.contains("w") && !StringUtils.containsOnly((CharSequence)date, (char[])new char[]{'Y'}) && !PATTERN_EXCEPTION.matcher(date).matches();
    }

    static {
        TARGET_CLASSES.add("SimpleDateFormat");
        TARGET_CLASSES.add("DateTimeFormatter");
        PATTERN_EXCEPTION = Pattern.compile(".*y{1,4}.*Y{1,4}.*|.*Y{1,4}.*y{1,4}.*");
    }
}

