/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.FunctionClassification;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.utility.statistic.InvocationStatistic;
import com.pvsstudio.warnings.WarningLevel;
import java.lang.invoke.LambdaMetafactory;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.EarlyTerminatingScanner;

public class V6121
extends PvsStudioRule {
    private static final Set<String> NAMES_TO_IGNORE = Set.of("configure", "add", "update", "set", "resolve", "pop", "remove", "append", "execute", "invoke", "insert", "test", "read", "next", "move", "trigger", "dequeue", "on", "throws", "handle", "open", "accept", "register", "visit", "expect", "apply", "exec", "put", "push");
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Return value is not always used. Consider inspecting the '%s' method.").setLevel(WarningLevel.LEVEL_2).build();
    private static final double CALL_FREQUENCY_THRESHOLD = 0.1;
    private static final int THRESHOLD_FOR_NUMBER_OF_CALLS_IN_ONE_FILE = 1;
    private final InvocationStatistic localStatistic = new InvocationStatistic();
    private static final String IS_METHOD_EXCEPTION = "is_V6121_method_exception";

    /*
     * Unable to fully structure code
     */
    private boolean isMethodException(@NotNull CtInvocation<?> invocation) {
        if (this.getMethodAnnotation((CtAbstractInvocation<?>)invocation).is(FunctionClassification.NoDiscard)) {
            return true;
        }
        executableReference = invocation.getExecutable();
        returnedType = executableReference.getType();
        if (executableReference.getType() == null || executableReference.isConstructor() || this.doesMethodReturnVoidOrBoolean(executableReference)) {
            return true;
        }
        declaration = executableReference.getDeclaration();
        if (declaration == null) {
            return true;
        }
        result = declaration.getMetadata("is_V6121_method_exception");
        if (result != null) {
            return (Boolean)result;
        }
        if (declaration.getPosition() instanceof NoSourcePosition || returnedType.equals((Object)executableReference.getDeclaringType()) || RulesUtils.implementsType(returnedType, "java.lang.Exception", true)) ** GOTO lbl-1000
        if (RulesUtils.splitName(executableReference.getSimpleName()).stream().map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toLowerCase(), (Ljava/lang/String;)Ljava/lang/String;)()).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(V6121.NAMES_TO_IGNORE)) || Optional.of(declaration).map((Function<CtExecutable, CtTypeReference>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getType(), (Lspoon/reflect/declaration/CtExecutable;)Lspoon/reflect/reference/CtTypeReference;)()).map((Function<CtTypeReference, CtTypeReference>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSuperclass(), (Lspoon/reflect/reference/CtTypeReference;)Lspoon/reflect/reference/CtTypeReference;)()).map((Function<CtTypeReference, CtType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getDeclaration(), (Lspoon/reflect/reference/CtTypeReference;)Lspoon/reflect/declaration/CtType;)()).filter((Predicate<CtType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$isMethodException$0(spoon.reflect.declaration.CtExecutable spoon.reflect.declaration.CtType ), (Lspoon/reflect/declaration/CtType;)Z)((CtExecutable)declaration)).isPresent() || this.doesMethodBodyHaveException(declaration)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        result = v0;
        declaration.putMetadata("is_V6121_method_exception", result);
        return (Boolean)result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInvocationException(@NotNull CtInvocation<?> ctInvocation) {
        if (this.haveRelatedComments(ctInvocation)) return true;
        if (!Optional.of(ctInvocation).map(CtElement::getParent).filter(CtBlock.class::isInstance).map(CtElement::getParent).filter(CtTry.class::isInstance).isPresent()) return false;
        return true;
    }

    private boolean isResultNotUsed(@NotNull CtInvocation<?> ctInvocation) {
        if (ctInvocation.getTarget() instanceof CtInvocation) {
            return false;
        }
        CtElement statement = ctInvocation.getParent();
        if (statement instanceof CtLambda) {
            return this.doesMethodReturnVoidOrBoolean(((CtLambda)statement).getOverriddenMethod().getReference());
        }
        if (statement instanceof CtFor) {
            CtFor forStatement = (CtFor)statement;
            return forStatement.getForUpdate() != null && forStatement.getForUpdate().contains(ctInvocation) || forStatement.getForInit() != null && forStatement.getForInit().contains(ctInvocation);
        }
        return statement instanceof CtBlock;
    }

    private boolean doesMethodReturnVoidOrBoolean(@NotNull CtExecutableReference<?> executable) {
        String simpleName = executable.getType().getSimpleName();
        return simpleName.equals("void") || simpleName.equalsIgnoreCase("boolean");
    }

    private boolean areFieldsChange(CtElement element) {
        while (element instanceof CtFieldRead) {
            element = ((CtFieldRead)element).getTarget();
        }
        if (element instanceof CtVariableRead) {
            element = ((CtVariableRead)element).getVariable().getDeclaration();
        }
        return element instanceof CtThisAccess || element instanceof CtParameter;
    }

    private boolean doesMethodBodyHaveException(@NotNull CtExecutable<?> executable) {
        if (!executable.getThrownTypes().isEmpty()) {
            return true;
        }
        if (executable.getBody() == null || executable.getBody().getStatements().isEmpty()) {
            return false;
        }
        final MutableBoolean returnOnlyThisOrNullFlag = new MutableBoolean(true);
        EarlyTerminatingScanner<Boolean> executableScanner = new EarlyTerminatingScanner<Boolean>(){

            public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
                if (Optional.of(arrayWrite).map(CtTargetedExpression::getTarget).filter(CtVariableRead.class::isInstance).map(x -> (CtVariableRead)x).filter(x -> V6121.this.areFieldsChange((CtElement)x)).isPresent()) {
                    this.setResult(true);
                    this.terminate();
                }
            }

            public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
                if (V6121.this.areFieldsChange((CtElement)fieldWrite.getTarget())) {
                    this.setResult(true);
                    this.terminate();
                }
            }

            public void visitCtThrow(CtThrow throwStatement) {
                this.setResult(true);
                this.terminate();
            }

            public <R> void visitCtReturn(CtReturn<R> returnStatement) {
                if (!returnOnlyThisOrNullFlag.getValue().booleanValue()) {
                    return;
                }
                if (!(returnStatement.getReturnedExpression() instanceof CtThisAccess || returnStatement.getReturnedExpression() instanceof CtLiteral && returnStatement.getReturnedExpression().toString().equals("null"))) {
                    returnOnlyThisOrNullFlag.setFalse();
                }
            }

            public <T> void visitCtNewClass(CtNewClass<T> newClass) {
            }

            public void visitCtAnonymousExecutable(CtAnonymousExecutable anonymousExec) {
            }

            public <T> void visitCtLambda(CtLambda<T> lambda) {
            }
        };
        executable.accept((CtVisitor)executableScanner);
        return executableScanner.getResult() != null && (Boolean)executableScanner.getResult() != false || returnOnlyThisOrNullFlag.getValue() != false;
    }

    private boolean haveRelatedComments(@NotNull CtInvocation<?> checkingElement) {
        SourcePosition codePosition = checkingElement.getPosition();
        SourcePosition codePositionOfPreviousStatement = this.getSourcePositionOfPreviousStatement(checkingElement);
        return this.getModule().getComments(codePosition.getFile()).stream().filter(comment -> this.isRelatedComment(codePosition, comment.getPosition())).filter(comment -> codePositionOfPreviousStatement == null || !this.isRelatedComment(codePositionOfPreviousStatement, comment.getPosition())).anyMatch(comment -> !this.isPvsStudioComment(comment.getContent()));
    }

    @Nullable
    private SourcePosition getSourcePositionOfPreviousStatement(@NotNull CtInvocation<?> checkingElement) {
        return Optional.of(checkingElement).map(inv -> (CtBlock)inv.getParent(CtBlock.class)).filter(x -> x.getStatements() != null).map(CtStatementList::getStatements).filter(x -> x.indexOf(checkingElement) > 0).map(x -> (CtStatement)x.get(x.indexOf(checkingElement) - 1)).map(CtElement::getPosition).filter(x -> !(x instanceof NoSourcePosition)).orElse(null);
    }

    private boolean isRelatedComment(SourcePosition codePosition, SourcePosition commentPosition) {
        int codeStartLine = codePosition.getLine();
        int commentEndLine = commentPosition.getEndLine();
        return codeStartLine <= commentPosition.getLine() && codePosition.getEndLine() >= commentEndLine || codeStartLine - commentEndLine == 1;
    }

    private boolean isPvsStudioComment(@NotNull String comment) {
        String regex = "^[+-]V\\d{3,4}.*";
        Pattern pattern = Pattern.compile(regex);
        String[] words = comment.split(" ");
        return words.length > 0 && pattern.matcher(words[0]).matches();
    }

    void scanExternalObject(CtElement element) {
        CtScanner invocationScanner = new CtScanner(){

            public <T> void visitCtInvocation(CtInvocation<T> inv) {
                if (1.0 / (double)V6121.this.getSameInvocationsCount(inv) > 0.1) {
                    super.visitCtInvocation(inv);
                    return;
                }
                if (!V6121.this.isInsideTestSources((CtElement)inv) && !V6121.this.isMethodException(inv)) {
                    V6121.this.localStatistic.addInvocation(inv, V6121.this.isResultNotUsed(inv), V6121.this.isInvocationException(inv));
                }
                super.visitCtInvocation(inv);
            }
        };
        invocationScanner.scan(element);
        this.localStatistic.removeManyInvocationsInOneFile(1);
        if (this.localStatistic.isEmpty()) {
            return;
        }
        this.localStatistic.getInvocationsWithoutReturn(0.1).forEach(invocation -> this.rule.add((CtElement)invocation, invocation.getExecutable().getSimpleName()));
        this.localStatistic.clear();
    }

    private int getSameInvocationsCount(CtInvocation<?> invocation) {
        return Objects.requireNonNull(this.getJavaDataFlow(), "JavaDataFlow is not set").getSameInvocationsCount(invocation);
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        if (!(ctClass.getParent() instanceof CtPackage)) {
            return;
        }
        this.scanExternalObject((CtElement)ctClass);
    }

    public <T> void visitCtInterface(CtInterface<T> intrface) {
        if (!(intrface.getParent() instanceof CtPackage)) {
            return;
        }
        this.scanExternalObject((CtElement)intrface);
    }

    private static /* synthetic */ boolean lambda$isMethodException$0(CtExecutable declaration, CtType x) {
        return x.equals((Object)declaration.getParent());
    }
}

