/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.core.OptionalLong;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;

public class V6120
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("The result of '&' operator is '0' because the value of %s operand is '0'.").setLevel(WarningLevel.LEVEL_1).setCwe(682).build();
    private final PvsStudioRule.Pattern assertionLeftRule = new PvsStudioRule.PatternBuilder(this).setMessage("The '&=' operator does not change the value of the left operand because its initial value is '0'.").setLevel(WarningLevel.LEVEL_1).setCwe(682).build();
    private final PvsStudioRule.Pattern assertionRightRule = new PvsStudioRule.PatternBuilder(this).setMessage("The left operand of the '&=' operator is assigned '0' because the value of the right operand is '0'.").setLevel(WarningLevel.LEVEL_1).setCwe(682).build();

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (this.isBitAnd(operator)) {
            this.applyRule(operator.getLeftHandOperand(), operator.getRightHandOperand());
        }
    }

    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        if (this.isBitAnd(assignment)) {
            CtExpression left = assignment.getAssigned();
            CtExpression right = assignment.getAssignment();
            if (right instanceof CtLiteral) {
                return;
            }
            this.applyRule(left, right);
        }
    }

    private void applyRule(CtExpression<?> left, CtExpression<?> right) {
        List<CtExpression<?>> operands = List.of(left, right);
        Multimap zeroOperands = (Multimap)operands.stream().filter(CtVariableAccess.class::isInstance).map(CtVariableAccess.class::cast).collect(ArrayListMultimap::create, (map, operand) -> map.put(operand, (Object)this.equalsZero((CtExpression<?>)operand)), (rec$, x$0) -> ((ArrayListMultimap)rec$).putAll(x$0));
        if (zeroOperands.values().stream().filter(Predicate.isEqual(true)).count() == 2L) {
            return;
        }
        if (zeroOperands.entries().stream().map(Map.Entry::getKey).noneMatch(this::isFinalVariable)) {
            return;
        }
        zeroOperands.entries().forEach(entry -> {
            CtVariableAccess operand = (CtVariableAccess)entry.getKey();
            if (((Boolean)entry.getValue()).booleanValue()) {
                CtElement parent = operand.getParent();
                if (parent instanceof CtBinaryOperator) {
                    this.rule.add(operand.getParent(), operand);
                } else if (parent instanceof CtOperatorAssignment) {
                    CtOperatorAssignment assignment = (CtOperatorAssignment)parent;
                    if (assignment.getAssigned().equals((Object)operand)) {
                        this.assertionLeftRule.add(parent, new Object[0]);
                    } else {
                        this.assertionRightRule.add(parent, new Object[0]);
                    }
                }
            }
        });
    }

    private boolean isBitAnd(CtBinaryOperator<?> operator) {
        return this.isBitAnd(operator.getKind());
    }

    private boolean isBitAnd(CtOperatorAssignment<?, ?> assignment) {
        return this.isBitAnd(assignment.getKind());
    }

    private boolean isBitAnd(BinaryOperatorKind kind) {
        return kind == BinaryOperatorKind.BITAND;
    }

    private boolean equalsZero(CtExpression<?> expression) {
        IntegerVirtualValue virtualValue = this.getValue((CtElement)expression).toInteger();
        return Optional.ofNullable(virtualValue).map(IntegerVirtualValue::toLong).filter(OptionalLong::isPresent).map(OptionalLong::get).filter(Predicate.isEqual(0L)).isPresent();
    }

    private boolean isFinalVariable(CtVariableAccess<?> variableAccess) {
        CtVariable variable = variableAccess.getVariable().getDeclaration();
        return variable != null && variable.isFinal();
    }
}

