/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.helpers.TreeIterator;
import com.pvsstudio.helpers.TreeNode;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.reference.CtVariableReference;

public class V6119
extends PvsStudioRule {
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder(this).setCwe(480).setLevel(WarningLevel.LEVEL_1).setMessage("The result of '%s' expression is '0'. It is possible that the '|' operator should be used instead.").build();

    public <T, A extends T> void visitCtOperatorAssignment(@NotNull CtOperatorAssignment<T, A> operator) {
        if (this.isRuleTriggered((CtElement)operator, (CtElement)operator.getAssigned(), (CtElement)operator.getAssignment(), operator.getKind()) && this.findFinalVariableInExpression((CtCodeElement)operator.getAssignment())) {
            this.pattern.add((CtElement)operator, operator.toString());
        }
    }

    public <T> void visitCtBinaryOperator(@NotNull CtBinaryOperator<T> operator) {
        if (this.isRuleTriggered((CtElement)operator, (CtElement)operator.getLeftHandOperand(), (CtElement)operator.getRightHandOperand(), operator.getKind()) && this.findFinalVariableInExpression((CtCodeElement)operator)) {
            this.pattern.add((CtElement)operator, operator.toString());
        }
    }

    private boolean findFinalVariableInExpression(@NotNull CtCodeElement operator) {
        TreeIterator iterator = new TreeIterator(operator, this::createBinaryOperationNode);
        CtCodeElement node = iterator.getCurrentNode();
        while (node != null) {
            if (this.isFinalVariable(node)) {
                return true;
            }
            node = iterator.next();
        }
        return false;
    }

    private TreeNode createBinaryOperationNode(CtCodeElement element) {
        return new TreeNode(element){

            @Override
            public List<CtCodeElement> getChildrenHook() {
                CtCodeElement el = this.getElement();
                if (el instanceof CtBinaryOperator) {
                    CtBinaryOperator binaryOperator = (CtBinaryOperator)el;
                    ArrayList<CtCodeElement> list = new ArrayList<CtCodeElement>();
                    list.add((CtCodeElement)binaryOperator.getLeftHandOperand());
                    list.add((CtCodeElement)binaryOperator.getRightHandOperand());
                    return list;
                }
                return Collections.emptyList();
            }
        };
    }

    private boolean isFinalVariable(@NotNull CtCodeElement expression) {
        return Optional.of(expression).filter(ex -> ex instanceof CtVariableRead).map(CtVariableRead.class::cast).filter(variableRead -> variableRead.getVariable() != null).map(CtVariableAccess::getVariable).filter(variable -> variable.getDeclaration() != null).map(CtVariableReference::getDeclaration).filter(CtModifiable::isFinal).isPresent();
    }

    private boolean isRuleTriggered(@NotNull CtElement operator, @NotNull CtElement left, @NotNull CtElement right, @NotNull BinaryOperatorKind kind) {
        return kind == BinaryOperatorKind.BITAND && !this.isNotZero(this.getValue(operator).toInteger()) && this.isNotZero(this.getValue(left).toInteger()) && this.isNotZero(this.getValue(right).toInteger());
    }

    private boolean isNotZero(@Nullable IntegerVirtualValue integerVirtualValue) {
        return integerVirtualValue == null || integerVirtualValue.isInterval() || !integerVirtualValue.toLong().isPresent() || integerVirtualValue.toLong().get() != 0L;
    }
}

