/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.V5306;
import com.pvsstudio.utility.closeable.MatchesScanner;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6118
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("The original exception object '%s' was swallowed. Cause of original exception could be lost.").setCwe(390).setLevel(WarningLevel.LEVEL_3).build();
    private final PvsStudioRule.LinkedRule<V5306> owaspRule = new PvsStudioRule.LinkedRule<V5306>(this, V5306.class);

    public void visitCtCatch(CtCatch catchBlock) {
        CtExecutable<?> currentMethod = this.getCurrentMethod();
        if (currentMethod != null) {
            CtTypeReference exceptionType = catchBlock.getParameter().getType();
            if (exceptionType == null) {
                return;
            }
            if (catchBlock.getParameter().getMultiTypes().size() != 1) {
                return;
            }
            if (exceptionType.getSimpleName().toLowerCase().contains("interrupt") || exceptionType.getQualifiedName().equals(Exception.class.getName()) || exceptionType.getQualifiedName().equals(Throwable.class.getName())) {
                return;
            }
            if (!catchBlock.getElements((Filter)new TypeFilter(CtAssignment.class)).isEmpty()) {
                return;
            }
            for (CtComment comment : this.getComments((CtElement)catchBlock)) {
                String content = comment.getContent().toLowerCase();
                if (!content.contains("ignore") && !content.contains("nothing") && !content.contains("expected")) continue;
                return;
            }
            String parameterName = catchBlock.getParameter().getSimpleName();
            if (parameterName.toLowerCase().contains("ignore") || parameterName.toLowerCase().contains("expected")) {
                return;
            }
            List<CtVariableAccess<?>> allUsages = MatchesScanner.findAllVariableUsagesInMethod(currentMethod, catchBlock.getParameter());
            if (allUsages.stream().anyMatch(x -> x.getParent() instanceof CtAbstractInvocation || x.getParent() instanceof CtAssignment)) {
                return;
            }
            List invocationList = catchBlock.getElements((Filter)new TypeFilter(CtInvocation.class));
            List invocationNamesList = invocationList.stream().map(x -> x.getExecutable().getSimpleName()).collect(Collectors.toList());
            if (invocationNamesList.stream().anyMatch(x -> StringUtils.containsAnyIgnoreCase((CharSequence)x, (CharSequence[])new CharSequence[]{"debug", "log", "severe", "print", "warn", "trace", "info", "fatal", "error"}))) {
                return;
            }
            for (CtThrow ctThrow : catchBlock.getElements((Filter)new TypeFilter(CtThrow.class))) {
                CtConstructorCall ctConstructorCall;
                List args;
                if (!(ctThrow.getThrownExpression() instanceof CtConstructorCall) || !(args = (ctConstructorCall = (CtConstructorCall)ctThrow.getThrownExpression()).getArguments()).isEmpty() || this.isSuperClassAnError(ctConstructorCall.getType()) || !this.isNotCustomException(ctConstructorCall)) continue;
                this.rule.add((CtElement)catchBlock.getParameter(), exceptionType.getSimpleName());
                this.owaspRule.get().apply(catchBlock.getParameter(), exceptionType.getSimpleName());
                return;
            }
        }
    }

    private boolean isNotCustomException(@NotNull CtConstructorCall<?> ctConstructorCall) {
        CtType typeReference = ctConstructorCall.getType().getTypeDeclaration();
        if (typeReference == null) {
            return false;
        }
        List constructors = typeReference.getTypeMembers().stream().filter(x -> x instanceof CtConstructor).map(x -> (CtConstructor)x).collect(Collectors.toList());
        Optional<CtInvocation> ignoreLiteralConstructor = constructors.stream().filter(c -> c.getParameters().isEmpty()).filter(c -> c.getBody().getStatements().size() == 1).filter(c -> c.getBody().getStatements().get(0) instanceof CtInvocation).map(c -> (CtInvocation)c.getBody().getStatements().get(0)).filter(i -> i.getArguments().size() == 1).filter(i -> i.getArguments().get(0) instanceof CtLiteral).filter(i -> i.getExecutable().getSimpleName().equals("<init>")).findAny();
        if (ignoreLiteralConstructor.isPresent()) {
            return false;
        }
        for (CtConstructor constructor : constructors) {
            List param = constructor.getParameters();
            if (param.size() == 1 && ((CtParameter)param.get(0)).getType().getQualifiedName() != null && ((CtParameter)param.get(0)).getType().getQualifiedName().equals(String.class.getName())) {
                return true;
            }
            if (param.size() == 1 && ((CtParameter)param.get(0)).getType().getQualifiedName() != null && ((CtParameter)param.get(0)).getType().getQualifiedName().equals(Throwable.class.getName())) {
                return true;
            }
            if (param.size() != 2 || ((CtParameter)param.get(0)).getType().getQualifiedName() == null || !((CtParameter)param.get(0)).getType().getQualifiedName().equals(String.class.getName()) || ((CtParameter)param.get(1)).getType().getQualifiedName() == null || !((CtParameter)param.get(1)).getType().getQualifiedName().equals(Throwable.class.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isSuperClassAnError(@NotNull CtTypeReference<?> ctTypeReference) {
        for (CtTypeReference superClass = ctTypeReference; superClass != null && superClass.getSuperclass() != null; superClass = superClass.getSuperclass()) {
            if (!superClass.getQualifiedName().equals(Error.class.getName())) continue;
            return true;
        }
        return false;
    }
}

