/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Int128;
import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.core.OptionalInt128;
import com.pvsstudio.core.OptionalLong;
import com.pvsstudio.helpers.TreeIterator;
import com.pvsstudio.helpers.TreeNode;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.V5308;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;

public class V6117
extends PvsStudioRule {
    private final PvsStudioRule.Pattern preciseRule = new PvsStudioRule.PatternBuilder().setMessage("An overflow will occur. The expression will be evaluated before casting. Consider casting one of the operands instead.").setLevel(WarningLevel.LEVEL_1).setCwe(190).setSastId("CERT-NUM00-J").setSecId("SEC-OVERFLOW-OR-INT-UINT").build();
    private final PvsStudioRule.Pattern generalRule = new PvsStudioRule.PatternBuilder().setMessage("Possible overflow. The expression will be evaluated before casting. Consider casting one of the operands instead.").setLevel(WarningLevel.LEVEL_2).setCwe(190).setSastId("CERT-NUM00-J").setSecId("SEC-OVERFLOW-OR-INT-UINT").build();
    private final PvsStudioRule.LinkedRule<V5308> linkedRule = new PvsStudioRule.LinkedRule<V5308>(V5308.class);

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        List casts = operator.getTypeCasts();
        if (casts.isEmpty()) {
            return;
        }
        CtTypeReference cast = (CtTypeReference)casts.get(casts.size() - 1);
        if (cast.getSimpleName().equals("long")) {
            Optional.of(operator).map(CtBinaryOperator.class::cast).filter(this::isIntegerOperator).filter(this::isArithmeticOperator).ifPresent(this::applyRule);
        }
    }

    private void applyRule(CtBinaryOperator<?> binaryOperator) {
        ArrayList binaryOperators = new ArrayList(this.findIntegerOperators(binaryOperator));
        Collections.reverse(binaryOperators);
        block5: for (CtBinaryOperator<?> integerOperator : binaryOperators) {
            switch (this.evaluateOverflow(integerOperator).ordinal()) {
                case 2: {
                    this.preciseRule.add((CtElement)integerOperator, integerOperator);
                    this.linkedRule.get().applyPrecise(integerOperator);
                    return;
                }
                case 1: {
                    this.generalRule.add((CtElement)integerOperator, integerOperator);
                    this.linkedRule.get().applyGeneral(integerOperator);
                    return;
                }
                case 0: {
                    continue block5;
                }
            }
        }
    }

    private List<CtBinaryOperator<?>> findIntegerOperators(CtBinaryOperator<?> operator) {
        ArrayList operators = new ArrayList();
        operators.add(operator);
        TreeIterator iterator = new TreeIterator((CtCodeElement)operator, this::createBinaryOperationNode);
        CtCodeElement element = iterator.next();
        while (element != null) {
            if (element instanceof CtBinaryOperator) {
                operators.add((CtBinaryOperator)element);
            }
            element = iterator.next();
        }
        return operators;
    }

    private OverflowPossibility evaluateOverflow(CtBinaryOperator<?> operator) {
        IntegerVirtualValue virtualValue = this.getValue((CtElement)operator).toInteger();
        if (virtualValue != null) {
            if (virtualValue.isOverflow()) {
                return OverflowPossibility.WILL_OVERFLOW;
            }
            OptionalInt128 minPreciseOptional = virtualValue.minPrecise();
            OptionalInt128 maxPreciseOptional = virtualValue.maxPrecise();
            if (minPreciseOptional.isPresent() && maxPreciseOptional.isPresent()) {
                Int128 minPrecise = minPreciseOptional.get();
                Int128 maxPrecise = maxPreciseOptional.get();
                if (minPrecise.toLong().isPresent() && maxPrecise.toLong().isPresent() && minPrecise.toLong().get() >= Integer.MIN_VALUE && maxPrecise.toLong().get() <= Integer.MAX_VALUE) {
                    return OverflowPossibility.WILL_NOT_OVERFLOW;
                }
            }
            OptionalLong minOptional = virtualValue.min().toLong();
            OptionalLong maxOptional = virtualValue.max().toLong();
            if (minOptional.get() == Integer.MIN_VALUE && maxOptional.get() == Integer.MAX_VALUE) {
                return OverflowPossibility.MAY_OVERFLOW;
            }
            if (minOptional.isPresent() && maxOptional.isPresent() && minOptional.get() >= Integer.MIN_VALUE && maxOptional.get() <= Integer.MAX_VALUE) {
                return OverflowPossibility.WILL_NOT_OVERFLOW;
            }
            return OverflowPossibility.MAY_OVERFLOW;
        }
        return OverflowPossibility.MAY_OVERFLOW;
    }

    private boolean isIntegerOperator(CtBinaryOperator<?> binaryOperator) {
        return binaryOperator.getType().getSimpleName().equals("int");
    }

    private TreeNode createBinaryOperationNode(CtCodeElement element) {
        return new TreeNode(element){

            @Override
            public List<CtCodeElement> getChildrenHook() {
                Optional<CtCodeElement> element = Optional.of(this.getElement());
                ArrayList<CtCodeElement> list = new ArrayList<CtCodeElement>();
                element.filter(CtBinaryOperator.class::isInstance).map(CtBinaryOperator.class::cast).filter(x$0 -> V6117.this.isIntegerOperator((CtBinaryOperator<?>)x$0)).ifPresent(operator -> list.addAll(List.of(operator.getLeftHandOperand(), operator.getRightHandOperand())));
                return list;
            }
        };
    }

    private boolean isArithmeticOperator(CtBinaryOperator<?> binaryOperator) {
        return binaryOperator.getKind() == BinaryOperatorKind.MUL || binaryOperator.getKind() == BinaryOperatorKind.PLUS || binaryOperator.getKind() == BinaryOperatorKind.MINUS;
    }

    private static enum OverflowPossibility {
        WILL_NOT_OVERFLOW,
        MAY_OVERFLOW,
        WILL_OVERFLOW;

    }
}

