/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.utility.closeable.CloseableFieldsAnalyzer;
import com.pvsstudio.utility.closeable.FieldMetaInfo;
import com.pvsstudio.utility.closeable.MethodMetaInfo;
import com.pvsstudio.warnings.WarningLevel;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtMethod;

public class V6116
extends PvsStudioRule {
    private final PvsStudioRule.Pattern classRule = new PvsStudioRule.PatternBuilder(this).setMessage("The '%s' class does not implement the Closeable interface, but it contains the 'close' method that releases resources.").setLevel(WarningLevel.LEVEL_3).setCwe(459).setSecId("SEC-LEAKS").build();
    private final PvsStudioRule.Pattern anonymousClassRule = new PvsStudioRule.PatternBuilder(this).setMessage("The anonymous class does not implement the Closeable interface, but it contains the 'close' method that releases resources.").setLevel(WarningLevel.LEVEL_3).setCwe(459).setSecId("SEC-LEAKS").build();

    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.apply((CtClass<?>)ctEnum);
    }

    public <T> void visitCtClass(@NotNull CtClass<T> ctClass) {
        this.apply(ctClass);
    }

    public void apply(@NotNull CtClass<?> ctClass) {
        if (this.isInsideTestSources((CtElement)ctClass) || CloseableFieldsAnalyzer.hasCloseableInterface(ctClass.getReference(), true)) {
            return;
        }
        CtMethod<?> closeMethod = CloseableFieldsAnalyzer.findCloseMethod(ctClass);
        if (closeMethod == null) {
            return;
        }
        if (!this.isAnyResourceClosed(ctClass, closeMethod)) {
            return;
        }
        if (ctClass.isAnonymous()) {
            this.anonymousClassRule.add((CtElement)closeMethod, new Object[0]).addSourcePosition((CtElement)ctClass, this.getModule());
        } else {
            this.classRule.add((CtElement)closeMethod, ctClass.getSimpleName()).addSourcePosition((CtElement)ctClass, this.getModule());
        }
    }

    private boolean isAnyResourceClosed(@NotNull CtClass<?> ctClass, @NotNull CtMethod<?> closeMethod) {
        byte depth = 1;
        CloseableFieldsAnalyzer closeableFieldsAnalyzer = new CloseableFieldsAnalyzer(ctClass, depth);
        closeableFieldsAnalyzer.findCloseableFields();
        if (closeableFieldsAnalyzer.areNoCloseableFields()) {
            return false;
        }
        closeableFieldsAnalyzer.findMethodsThatCloseArgument();
        closeableFieldsAnalyzer.scan();
        return closeableFieldsAnalyzer.getCloseableFields().stream().filter(FieldMetaInfo::isClosed).anyMatch(field -> field.getMethodsWithFieldClosingInside().stream().map(MethodMetaInfo::getMethod).anyMatch(method -> method.getReference().getExecutableDeclaration().equals((Object)closeMethod)));
    }
}

