/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.utility.closeable.CloseableFieldsAnalyzer;
import com.pvsstudio.utility.closeable.FieldMetaInfo;
import com.pvsstudio.utility.closeable.MethodMetaInfo;
import com.pvsstudio.warnings.WarningLevel;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;

public class V6115
extends PvsStudioRule {
    final String message = "The '%s' class implements %s interface, but the '%s' field is not released inside the 'close' method.";
    final String anonymousMessage = "The anonymous class implements %s interface, but the '%s' field is not released inside the 'close' method.";
    private final PvsStudioRule.PatternBuilder patternBuilder = new PvsStudioRule.PatternBuilder();

    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.apply((CtClass<?>)ctEnum);
    }

    public <T> void visitCtClass(@NotNull CtClass<T> ctClass) {
        this.apply(ctClass);
    }

    private boolean isRuleException(@NotNull CtClass<?> ctClass, @Nullable CtMethod<?> closeMethod) {
        return this.isInsideTestSources((CtElement)ctClass) || ctClass.isAbstract() || !CloseableFieldsAnalyzer.hasCloseableInterface(ctClass.getReference(), true) || CloseableFieldsAnalyzer.isTypeHaveDefaultOrFinalCloseInHierarchy(ctClass, closeMethod);
    }

    public void apply(@NotNull CtClass<?> ctClass) {
        CtMethod<?> closeMethod = CloseableFieldsAnalyzer.findCloseMethod(ctClass);
        if (this.isRuleException(ctClass, closeMethod)) {
            return;
        }
        byte depth = 1;
        CloseableFieldsAnalyzer closeableFieldsAnalyzer = new CloseableFieldsAnalyzer(ctClass, depth);
        closeableFieldsAnalyzer.findCloseableFields();
        if (closeableFieldsAnalyzer.areNoCloseableFields()) {
            return;
        }
        closeableFieldsAnalyzer.findMethodsThatCloseArgument();
        closeableFieldsAnalyzer.scan();
        if (closeableFieldsAnalyzer.areNoCloseableFields()) {
            return;
        }
        String interfaceName = RulesUtils.implementsType(ctClass.getReference(), "java.io.Closeable", true) ? "Closeable" : "AutoCloseable";
        closeableFieldsAnalyzer.getCloseableFields().forEach(x -> this.addRuleToField((FieldMetaInfo)x, ctClass, closeMethod, interfaceName));
    }

    private void addRuleToField(@NotNull FieldMetaInfo analyzingField, @NotNull CtClass<?> analyzingClass, @Nullable CtMethod<?> closeMethod, @NotNull String implementedInterface) {
        if (analyzingField.isClosed() && closeMethod != null && analyzingField.getMethodsWithFieldClosingInside().stream().map(MethodMetaInfo::getMethod).collect(Collectors.toSet()).contains(closeMethod)) {
            return;
        }
        WarningLevel ruleLevel = analyzingField.isClosed() ? WarningLevel.LEVEL_3 : WarningLevel.LEVEL_2;
        CtField<?> field = analyzingField.getField();
        String usingMessage = analyzingClass.isAnonymous() ? "The anonymous class implements %s interface, but the '%s' field is not released inside the 'close' method." : "The '%s' class implements %s interface, but the '%s' field is not released inside the 'close' method.";
        PvsStudioRule.Pattern rule = this.patternBuilder.setMessage(usingMessage).setLevel(ruleLevel).setCwe(404).setSecId("SEC-LEAKS").build();
        WarningAdapter adapter = analyzingClass.isAnonymous() ? rule.add((CtElement)field, implementedInterface, field.getSimpleName()) : rule.add((CtElement)field, analyzingClass.getSimpleName(), implementedInterface, field.getSimpleName());
        if (closeMethod != null) {
            adapter.addSourcePosition((CtElement)closeMethod, this.getModule());
        }
    }
}

