/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.utility.closeable.CloseableFieldsAnalyzer;
import com.pvsstudio.utility.closeable.FieldMetaInfo;
import com.pvsstudio.warnings.WarningLevel;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtField;

public class V6114
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("The '%s' class contains the '%s' Closeable field, but the resources that the field is holding are not released inside the class.").setLevel(WarningLevel.LEVEL_2).setCwe(404).setSecId("SEC-LEAKS").build();
    private final PvsStudioRule.Pattern ruleAnonymousClass = new PvsStudioRule.PatternBuilder().setMessage("The anonymous class contains the '%s' Closeable field, but the resources that the field is holding are not released inside the class.").setLevel(WarningLevel.LEVEL_2).setCwe(404).setSecId("SEC-LEAKS").build();

    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.apply((CtClass<?>)ctEnum);
    }

    public <T> void visitCtClass(@NotNull CtClass<T> ctClass) {
        this.apply(ctClass);
    }

    private boolean isRuleException(@NotNull CtClass<?> ctClass) {
        return this.isInsideTestSources((CtElement)ctClass) || ctClass.isAbstract() || CloseableFieldsAnalyzer.hasCloseableInterface(ctClass.getReference(), true) && !CloseableFieldsAnalyzer.isTypeHaveDefaultOrFinalCloseInHierarchy(ctClass, CloseableFieldsAnalyzer.findCloseMethod(ctClass));
    }

    public void apply(@NotNull CtClass<?> ctClass) {
        if (this.isRuleException(ctClass)) {
            return;
        }
        CloseableFieldsAnalyzer closeableFieldsAnalyzer = new CloseableFieldsAnalyzer(ctClass);
        closeableFieldsAnalyzer.findCloseableFields();
        if (closeableFieldsAnalyzer.areNoCloseableFields()) {
            return;
        }
        closeableFieldsAnalyzer.findMethodsThatCloseArgument();
        closeableFieldsAnalyzer.scan();
        if (closeableFieldsAnalyzer.areNoCloseableFields()) {
            return;
        }
        for (FieldMetaInfo fieldMetaInfo : closeableFieldsAnalyzer.getCloseableFields()) {
            if (fieldMetaInfo.isClosed()) continue;
            CtField<?> field = fieldMetaInfo.getField();
            if (ctClass.isAnonymous()) {
                this.ruleAnonymousClass.add((CtElement)field, field.getSimpleName());
                continue;
            }
            this.rule.add((CtElement)field, ctClass.getSimpleName(), field.getSimpleName());
        }
    }
}

