/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.core.OptionalLong;
import com.pvsstudio.core.Value;
import com.pvsstudio.helpers.TreeIterator;
import com.pvsstudio.helpers.TreeNode;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtReference;

public class V6113
extends PvsStudioRule {
    private final PvsStudioRule.Pattern ruleMod = new PvsStudioRule.PatternBuilder(this).setCwe(682).setLevel(WarningLevel.LEVEL_2).setMessage("The '%s' expression evaluates to the value of the left operand because its absolute value '%s' is less than the value of the right operand '%s'.").build();
    private final PvsStudioRule.Pattern ruleDiv = new PvsStudioRule.PatternBuilder(this).setCwe(682).setLevel(WarningLevel.LEVEL_2).setMessage("The '%s' expression evaluates to 0 because the absolute value of the left operand '%s' is less than the value of the right operand '%s'.").build();
    private final PvsStudioRule.Pattern ruleModInExpression = new PvsStudioRule.PatternBuilder(this).setCwe(682).setLevel(WarningLevel.LEVEL_2).setMessage("The '%s' subexpression evaluates to the value of the left operand because its absolute value '%s' is less than the value of the right operand '%s'.").build();
    private static final long MAX_ABSOLUTE_VALUE = Long.MIN_VALUE;
    private static final long MIN_ABSOLUTE_VALUE = 0L;
    private static final String MAX_VALUE_FILED_NAME = "MAX_VALUE";
    private static final String MIN_VALUE_FILED_NAME = "MIN_VALUE";

    public <T, A extends T> void visitCtOperatorAssignment(@NotNull CtOperatorAssignment<T, A> operator) {
        if (this.isDivOrMod(operator.getKind()) && this.isApplicable(operator.getAssigned(), operator.getAssignment())) {
            this.addRule((CtExpression<?>)operator, (CtExpression<?>)operator.getAssigned(), (CtExpression<?>)operator.getAssignment(), operator.getKind());
        }
    }

    public <T> void visitCtBinaryOperator(@NotNull CtBinaryOperator<T> operator) {
        CtBinaryOperator operatorWithError = Optional.of(operator).filter(this::isDivOrMod).filter(x -> !this.isDivOrMod(x.getParent())).map(this::findFirstNodeWithError).orElse(null);
        if (operatorWithError == null) {
            return;
        }
        if (operatorWithError == operator) {
            this.addRule((CtExpression<?>)operator, (CtExpression<?>)operator.getLeftHandOperand(), (CtExpression<?>)operator.getRightHandOperand(), operator.getKind());
        } else {
            this.ruleModInExpression.add((CtElement)operatorWithError, operatorWithError, operator, operatorWithError.getLeftHandOperand(), operatorWithError.getRightHandOperand());
        }
    }

    private boolean isDivOrMod(@NotNull CtElement element) {
        return Optional.of(element).filter(x -> x instanceof CtBinaryOperator).map(x -> (CtBinaryOperator)x).map(CtBinaryOperator::getKind).filter(this::isDivOrMod).isPresent();
    }

    private boolean isDivOrMod(@NotNull BinaryOperatorKind operatorKind) {
        return operatorKind == BinaryOperatorKind.DIV || operatorKind == BinaryOperatorKind.MOD;
    }

    private TreeNode createBinaryOperationNode(CtCodeElement element) {
        return new TreeNode(element){

            @Override
            public List<CtCodeElement> getChildrenHook() {
                CtCodeElement el = this.getElement();
                if (V6113.this.isDivOrMod((CtElement)el)) {
                    CtBinaryOperator binaryOperator = (CtBinaryOperator)el;
                    ArrayList<CtCodeElement> list = new ArrayList<CtCodeElement>();
                    list.add((CtCodeElement)binaryOperator.getLeftHandOperand());
                    list.add((CtCodeElement)binaryOperator.getRightHandOperand());
                    return list;
                }
                return Collections.emptyList();
            }
        };
    }

    @Nullable
    private CtBinaryOperator<?> findFirstNodeWithError(@NotNull CtBinaryOperator<?> root) {
        TreeIterator iterator = new TreeIterator((CtCodeElement)root, this::createBinaryOperationNode);
        CtCodeElement node = iterator.getCurrentNode();
        while (node != null) {
            if (this.isApplicable(node)) {
                return (CtBinaryOperator)node;
            }
            node = iterator.next();
        }
        return null;
    }

    private void addRule(@NotNull CtExpression<?> operator, @NotNull CtExpression<?> left, @NotNull CtExpression<?> right, @NotNull BinaryOperatorKind kind) {
        PvsStudioRule.Pattern rulePattern = kind == BinaryOperatorKind.DIV ? this.ruleDiv : this.ruleMod;
        rulePattern.add((CtElement)operator, operator, left, right);
    }

    private long getMaxOrMinModuloValue(boolean getMaxFlag, Supplier<Long> minimumModuloValueProvider) {
        return getMaxFlag ? Long.MIN_VALUE : minimumModuloValueProvider.get();
    }

    Long getLimitValue(@NotNull IntegerVirtualValue interval, boolean getMaxFlag) {
        if (!interval.isInterval()) {
            OptionalLong intervalLong = interval.toLong();
            return intervalLong.isPresent() ? Long.valueOf(-Math.abs(intervalLong.get())) : null;
        }
        OptionalLong leftBorder = interval.min().toLong();
        OptionalLong rightBorder = interval.max().toLong();
        if (!leftBorder.isPresent() && !rightBorder.isPresent()) {
            return this.getMaxOrMinModuloValue(getMaxFlag, () -> 0L);
        }
        if (!leftBorder.isPresent() && rightBorder.isPresent()) {
            return this.getMaxOrMinModuloValue(getMaxFlag, () -> rightBorder.get() >= 0L ? 0L : rightBorder.get());
        }
        if (leftBorder.isPresent() && !rightBorder.isPresent()) {
            return this.getMaxOrMinModuloValue(getMaxFlag, () -> leftBorder.get() <= 0L ? 0L : -leftBorder.get());
        }
        long leftBorderValue = leftBorder.get();
        long rightBorderValue = rightBorder.get();
        if (getMaxFlag) {
            if (leftBorderValue == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (leftBorderValue == 0L) {
                return -rightBorderValue;
            }
            if (rightBorderValue == 0L) {
                return leftBorderValue;
            }
            if (leftBorderValue > 0L) {
                return -rightBorderValue;
            }
            if (rightBorderValue < 0L) {
                return leftBorderValue;
            }
            return -Math.max(Math.abs(leftBorderValue), rightBorderValue);
        }
        if (leftBorderValue == 0L) {
            return 0L;
        }
        if (rightBorderValue == 0L) {
            return 0L;
        }
        if (leftBorderValue > 0L) {
            return -leftBorderValue;
        }
        if (rightBorderValue < 0L) {
            return rightBorderValue;
        }
        return 0L;
    }

    private boolean isApplicable(@NotNull CtCodeElement element) {
        return Optional.of(element).filter(this::isDivOrMod).map(x -> (CtBinaryOperator)x).filter(x -> this.isApplicable(x.getLeftHandOperand(), x.getRightHandOperand())).isPresent();
    }

    private boolean isApplicable(@NotNull CtExpression<?> left, @NotNull CtExpression<?> right) {
        Long leftMaxValue = this.getValueFromIntegerExpression(left, true);
        if (leftMaxValue == null) {
            return false;
        }
        Long rightMinValue = this.getValueFromIntegerExpression(right, false);
        if (rightMinValue == null) {
            return false;
        }
        return leftMaxValue > rightMinValue;
    }

    @Nullable
    private Long getValueFromIntegerExpression(@NotNull CtExpression<?> expression, boolean getMaxFlag) {
        if (!RulesUtils.isIntegerType(expression) && !RulesUtils.isBoxedIntegerType(expression)) {
            return null;
        }
        IntegerVirtualValue interval = Optional.of(expression).map(this::getValue).map(Value::toInteger).orElse(null);
        Long value = interval != null ? this.getLimitValue(interval, getMaxFlag) : (expression instanceof CtFieldRead && this.isTypeLimitValue((CtFieldRead)expression) ? Long.valueOf(this.getTypeLimitValue((CtFieldRead)expression)) : null);
        return value;
    }

    private boolean isTypeLimitValue(@NotNull CtFieldRead<?> expression) {
        return Optional.of(expression).filter(x -> x.getTarget() instanceof CtTypeAccess).map(CtFieldAccess::getVariable).map(CtReference::getSimpleName).filter(x -> x.equals(MAX_VALUE_FILED_NAME) || x.equals(MIN_VALUE_FILED_NAME)).isPresent();
    }

    private boolean isCharacterTypeField(@NotNull CtFieldRead<?> field) {
        String fieldTypeQualifiedName = RulesUtils.getTypeName(field);
        return fieldTypeQualifiedName.equals("char") || fieldTypeQualifiedName.equals("java.lang.Character");
    }

    private long getTypeLimitValue(@NotNull CtFieldRead<?> field) {
        if (this.isCharacterTypeField(field)) {
            return field.getVariable().getSimpleName().equals(MIN_VALUE_FILED_NAME) ? 0L : -65535L;
        }
        return Optional.of(field).map(CtFieldAccess::getVariable).map(CtFieldReference::getFieldDeclaration).map(CtField::getAssignment).map(x -> (CtLiteral)x).map(CtLiteral::getValue).map(Number.class::cast).map(x -> -Math.abs(x.longValue())).orElse(Long.MIN_VALUE);
    }
}

