/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.reference.CtExecutableReference;

public class V6112
extends PvsStudioRule {
    private final PvsStudioRule.Pattern multipleUsingMethod = new PvsStudioRule.PatternBuilder().setMessage("Repeatedly calling the 'getClass' method on its own return value will always return the instance of the 'Class<Class>' type.").setLevel(WarningLevel.LEVEL_2).build();
    private final PvsStudioRule.Pattern unitedUsingFieldAndMethod = new PvsStudioRule.PatternBuilder().setMessage("Calling the 'getClass' method on the value of the '.class' literal will always return the instance of the 'Class<Class>' type.").setLevel(WarningLevel.LEVEL_2).build();
    private static final String SEARCHING_METHOD_NAME = "getClass";
    private static final String SEARCHING_FIELD_NAME = "class";
    private static final String EXCEPTION_TYPE_NAME = Class.class.getName();

    @Override
    public <T> void visitCtInvocation(@NotNull CtInvocation<T> inv) {
        if (this.isGetClassMethodCallChain(inv)) {
            this.multipleUsingMethod.add((CtElement)inv, new Object[0]);
        }
    }

    private boolean isGetClassMethodCallChain(@NotNull CtInvocation<?> inv) {
        if (!this.isGetClassMethodInvocation(inv) || this.isNotEndOfGetClassMethodCallChain(inv)) {
            return false;
        }
        CtInvocation lastLeftGetClassMethodInvocation = null;
        while (inv.getTarget() instanceof CtInvocation) {
            if (this.isGetClassMethodInvocation(inv = (CtInvocation)inv.getTarget())) {
                lastLeftGetClassMethodInvocation = inv;
                continue;
            }
            if (lastLeftGetClassMethodInvocation == null) break;
            return true;
        }
        if (this.isGetClassMethodCallWithClassObject(lastLeftGetClassMethodInvocation)) {
            return false;
        }
        return lastLeftGetClassMethodInvocation != null;
    }

    private boolean isGetClassMethodCallWithClassObject(CtInvocation<?> lastLeftGetClassMethodInvocation) {
        return Optional.ofNullable(lastLeftGetClassMethodInvocation).map(CtTargetedExpression::getTarget).map(CtTypedElement::getType).filter(x -> EXCEPTION_TYPE_NAME.equals(x.getQualifiedName())).isPresent();
    }

    private boolean isNotEndOfGetClassMethodCallChain(@NotNull CtInvocation<?> inv) {
        return Optional.of(inv).filter(x -> x.getParent() instanceof CtInvocation).map(x -> (CtInvocation)x.getParent()).filter(this::isGetClassMethodInvocation).isPresent();
    }

    public <T> void visitCtFieldRead(@NotNull CtFieldRead<T> fieldRead) {
        if (this.isFieldWithSpecialNameFromClassTypeAndGetClassMethodCall(fieldRead)) {
            this.unitedUsingFieldAndMethod.add((CtElement)fieldRead, new Object[0]);
        }
    }

    private boolean isFieldWithSpecialNameFromClassTypeAndGetClassMethodCall(@NotNull CtFieldRead<?> fieldRead) {
        if (this.isFieldWithSpecialNameFromClassType(fieldRead)) {
            return false;
        }
        return Optional.of(fieldRead).filter(x -> x.getVariable().getSimpleName().equals(SEARCHING_FIELD_NAME)).filter(x -> x.getParent() instanceof CtInvocation).map(x -> (CtInvocation)x.getParent()).filter(this::isGetClassMethodInvocation).isPresent();
    }

    private boolean isGetClassMethodInvocation(@NotNull CtInvocation<?> invocation) {
        CtExecutableReference executableReference = invocation.getExecutable();
        return invocation.getArguments().isEmpty() && executableReference != null && SEARCHING_METHOD_NAME.equals(executableReference.getSimpleName());
    }

    private boolean isFieldWithSpecialNameFromClassType(@NotNull CtFieldRead<?> fieldRead) {
        return Optional.of(fieldRead).filter(x -> x.getTarget() instanceof CtTypeAccess).map(x -> (CtTypeAccess)x.getTarget()).map(CtTypeAccess::getAccessedType).filter(x -> EXCEPTION_TYPE_NAME.equals(x.getQualifiedName())).isPresent();
    }
}

