/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.core.Value;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Optional;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.declaration.CtElement;

public class V6111
extends PvsStudioRule {
    private final PvsStudioRule.Pattern preciseRule;
    private final PvsStudioRule.Pattern vagueRule;

    public V6111() {
        PvsStudioRule.PatternBuilder builder = new PvsStudioRule.PatternBuilder().setLevel(WarningLevel.LEVEL_1).setCwe(839);
        this.preciseRule = builder.setMessage("The value used as the size of an array could reach %s. Consider inspecting: %s.").build();
        this.vagueRule = builder.setMessage("The value used as the size of an array could reach negative value. Consider inspecting: %s.").build();
    }

    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        List sizes = newArray.getDimensionExpressions();
        for (CtExpression size : sizes) {
            IntegerVirtualValue virtualInt = Optional.of(this.getValue((CtElement)size)).filter(x -> !x.isEmpty()).map(Value::toInteger).filter(x -> x.containsPreciseFromRange(-2147483647L, -1L)).orElse(null);
            if (virtualInt == null) continue;
            if (virtualInt.minPrecise().isPresent()) {
                this.preciseRule.add((CtElement)size, virtualInt.minPrecise().get(), size);
                continue;
            }
            this.vagueRule.add((CtElement)size, size);
        }
    }
}

