/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.OptionalStringVirtualValue;
import com.pvsstudio.core.VirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;

public class V6110
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Using the '%s' environment variable could be unsafe or unreliable. Consider using trusted system property '%s' instead.").setLevel(WarningLevel.LEVEL_3).setSastId("CERT-ENV02-J").build();
    private static final Map<String, String> targetMap = Map.ofEntries(Map.entry("JAVA_VERSION", "java.version"), Map.entry("TEMP", "java.io.tmpdir"), Map.entry("TMP", "java.io.tmpdir"), Map.entry("PROCESSOR_ARCHITECTURE", "os.arch"), Map.entry("OS", "os.name"), Map.entry("USER", "user.name"), Map.entry("USERNAME", "user.name"), Map.entry("HOME", "user.home"), Map.entry("HOMEPATH", "user.home"), Map.entry("CD", "user.dir"), Map.entry("PWD", "user.dir"));

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        if (this.isTargetInvocation(inv) && !inv.getArguments().isEmpty()) {
            OptionalStringVirtualValue value;
            VirtualValue virtualValue;
            CtExpression ex = (CtExpression)inv.getArguments().get(0);
            Object objectConst = RulesUtils.getConstantExpression(this.getDataFlow().getVariablesCache(), ex);
            if (objectConst != null) {
                this.checkRule(inv, objectConst);
            } else if (ex instanceof CtVariableAccess && !(virtualValue = this.getValue((CtElement)ex).getVirtualValue()).isEmpty() && (value = virtualValue.getString()).isPresent()) {
                this.checkRule(inv, value.get().singletonValue().toString());
            }
        }
    }

    private void checkRule(CtInvocation<?> inv, Object value) {
        Set<String> keyset;
        Optional<String> optional;
        if (value instanceof String && (optional = (keyset = targetMap.keySet()).stream().filter(t -> t.equalsIgnoreCase((String)value)).findAny()).isPresent()) {
            String s = optional.get();
            if (this.isStringMap(inv.getExecutable()) && (s.equalsIgnoreCase("USER") || s.equalsIgnoreCase("USERNAME") || s.equalsIgnoreCase("HOME") || s.equalsIgnoreCase("HOMEPATH"))) {
                return;
            }
            this.rule.add((CtElement)inv, s, targetMap.get(s));
        }
    }

    private boolean isTargetInvocation(CtInvocation<?> inv) {
        CtExecutableReference exe = inv.getExecutable();
        if (exe == null) {
            return false;
        }
        if (this.isStringMap(exe)) {
            return true;
        }
        if (exe.toString().equals("getenv(" + String.class.getName() + ")")) {
            return true;
        }
        if (exe.getType() != null && exe.getType().getSimpleName().equals("String") && exe.getSimpleName().toLowerCase().contains("env") && !exe.getParameters().isEmpty() && exe.getParameters().size() <= 2) {
            return exe.getParameters().stream().allMatch(s -> s.getSimpleName().equals("String"));
        }
        return false;
    }

    private boolean isStringMap(CtExecutableReference<?> exe) {
        return (exe.getSimpleName().equals("get") || exe.getSimpleName().equals("getOrDefault")) && exe.getDeclaringType() != null && exe.getDeclaringType().getSimpleName().equals("Map");
    }
}

