/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.OptionalLong;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.V5307;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6109
extends PvsStudioRule {
    public static final String MESSAGE = "Potentially predictable seed is used in pseudo-random number generator.";
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Potentially predictable seed is used in pseudo-random number generator.").setCwe(337).setLevel(WarningLevel.LEVEL_3).setSecId("SEC-SECURITY").build();
    private final PvsStudioRule.Pattern ruleTime = new PvsStudioRule.PatternBuilder().setMessage("Potentially predictable seed is used in pseudo-random number generator.").setCwe(337).setLevel(WarningLevel.LEVEL_1).setSecId("SEC-SECURITY").build();
    private final PvsStudioRule.Pattern ruleConst = new PvsStudioRule.PatternBuilder().setMessage("Constant seed '%s' is used in a pseudo-random number generator.").setCwe(336).setLevel(WarningLevel.LEVEL_1).setSecId("SEC-SECURITY").build();
    private final PvsStudioRule.VariableInformation<List<Warning>> variables = new PvsStudioRule.VariableInformation<List>(ArrayList::new);
    private final PvsStudioRule.LinkedRule<V5307> owaspRule = new PvsStudioRule.LinkedRule<V5307>(V5307.class);

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        CtClass clazz;
        if (this.isInsideTestSources((CtElement)inv)) {
            return;
        }
        CtExecutable<?> currentMethod = this.getCurrentMethod();
        if (currentMethod != null && currentMethod.getParent() instanceof CtClass && this.isTestClassName((clazz = (CtClass)currentMethod.getParent()).getQualifiedName().toLowerCase())) {
            return;
        }
        CtExecutableReference exe = inv.getExecutable();
        if (exe != null && exe.getDeclaringType() != null && V6109.isRandom(exe.getDeclaringType().getQualifiedName()) && !exe.getParameters().isEmpty() && exe.getSimpleName().equals("setSeed")) {
            this.checkDataFlowRule((CtAbstractInvocation<?>)inv);
        }
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> inv) {
        CtExecutable<?> currentMethod;
        CtMethod method;
        if (this.isInsideTestSources((CtElement)inv)) {
            return;
        }
        CtExecutableReference exe = inv.getExecutable();
        CtTypeReference type = exe.getType();
        String qualifiedName = type.getQualifiedName();
        if (qualifiedName != null && V6109.isRandom(qualifiedName) && (method = RulesUtils.getParentBounded(inv, currentMethod = this.getCurrentMethod(), CtMethod.class)) != null) {
            CtInvocation parentInv;
            CtClass clazz;
            if (method.getParent() instanceof CtClass && this.isTestClassName((clazz = (CtClass)method.getParent()).getQualifiedName().toLowerCase())) {
                return;
            }
            if (method.getType().getQualifiedName() != null && V6109.isRandom(method.getType().getQualifiedName())) {
                return;
            }
            if (inv.getParent() instanceof CtConstructorCall) {
                return;
            }
            if (inv.getParent() instanceof CtInvocation && !V6109.isRandom((parentInv = (CtInvocation)inv.getParent()).getTarget().getType().getQualifiedName())) {
                return;
            }
            if (!exe.getParameters().isEmpty()) {
                this.checkDataFlowRule((CtAbstractInvocation<?>)inv);
            } else {
                CtVariableWrite var;
                CtVariable v;
                CtAssignment<?, ?> ass = V6109.getAssignment(inv);
                if (ass != null && ass.getAssigned() instanceof CtVariableWrite && (v = (var = (CtVariableWrite)ass.getAssigned()).getVariable().getDeclaration()) instanceof CtField) {
                    return;
                }
                if (method.getSimpleName().equals("main") && method.hasModifier(ModifierKind.STATIC) && method.hasModifier(ModifierKind.PUBLIC)) {
                    return;
                }
                this.addRule((CtAbstractInvocation<?>)inv, this.rule, new Object[0]);
            }
        }
    }

    @Override
    public void exit(CtElement element) {
        if (element instanceof CtMethod) {
            this.variables.clear();
        }
    }

    private void checkDataFlowRule(CtAbstractInvocation<?> inv) {
        OptionalLong charCode;
        CtExpression arg = (CtExpression)inv.getArguments().get(0);
        if (this.checkMethod((CtElement)arg)) {
            this.addRule(inv, this.ruleTime, new Object[0]);
            return;
        }
        if (arg instanceof CtVariableRead && this.getJavaDataFlow() != null) {
            CtVariableRead variableRead = (CtVariableRead)arg;
            CtElement element = this.getJavaDataFlow().getVariableExpression((CtVariableAccess<?>)variableRead, (CtElement)arg);
            if (this.checkMethod(element)) {
                this.addRule(inv, this.ruleTime, new Object[0]);
                return;
            }
        }
        if (arg != null && (RulesUtils.isIntegerType(arg) || RulesUtils.isBoxedIntegerType(arg)) && (charCode = this.getValue((CtElement)inv.getArguments().get(0)).getVirtualValue().toLong()).isPresent()) {
            this.addRule(inv, this.ruleConst, charCode.get());
        }
    }

    private boolean checkMethod(CtElement invocation) {
        if (!(invocation instanceof CtInvocation)) {
            return false;
        }
        String name = ((CtInvocation)invocation).getExecutable().getSimpleName();
        return name.equals("currentTimeMillis") || name.equals("nanoTime") || name.equals("getTime");
    }

    private void addRule(CtAbstractInvocation<?> inv, PvsStudioRule.Pattern rule, Object ... array) {
        CtVariable var = null;
        if (V6109.isLocalVariable(inv)) {
            var = (CtVariable)inv.getParent((Filter)new TypeFilter(CtLocalVariable.class));
        } else if (inv instanceof CtInvocation) {
            CtInvocation i = (CtInvocation)inv;
            if (i.getTarget() instanceof CtVariableAccess) {
                var = ((CtVariableAccess)i.getTarget()).getVariable().getDeclaration();
            }
        } else {
            CtAssignment<?, ?> ass = V6109.getAssignment(inv);
            if (ass != null && ass.getAssigned() instanceof CtVariableWrite) {
                var = ((CtVariableWrite)ass.getAssigned()).getVariable().getDeclaration();
            }
        }
        if (var != null) {
            List<Warning> varCache = this.variables.get(var);
            if (!varCache.isEmpty() && rule.getLevel() == WarningLevel.LEVEL_1) {
                List l3Warnings = this.getAnalyzer().getWarnings().stream().filter(varCache::contains).filter(w -> w.level == WarningLevel.LEVEL_3).collect(Collectors.toList());
                if (!l3Warnings.isEmpty()) {
                    this.getAnalyzer().getWarnings().removeAll(l3Warnings);
                    rule.add((CtElement)inv, array);
                    this.addOwasp(inv, rule, array);
                    return;
                }
            }
            varCache.add(rule.add((CtElement)inv, array).getWarning());
            varCache.add(this.addOwasp(inv, rule, array));
        } else {
            rule.add((CtElement)inv, array);
            this.addOwasp(inv, rule, array);
        }
    }

    private Warning addOwasp(CtAbstractInvocation<?> inv, PvsStudioRule.Pattern rule, Object ... array) {
        if (rule == this.rule) {
            return this.owaspRule.get().apply(inv, array);
        }
        if (rule == this.ruleTime) {
            return this.owaspRule.get().applyTime(inv, array);
        }
        return this.owaspRule.get().applyConst(inv, array);
    }

    private static <T> boolean isLocalVariable(CtAbstractInvocation<T> inv) {
        return inv.getParent((Filter)new TypeFilter(CtLocalVariable.class)) != null;
    }

    private static <T> CtAssignment<?, ?> getAssignment(CtAbstractInvocation<T> inv) {
        return (CtAssignment)inv.getParent((Filter)new TypeFilter(CtAssignment.class));
    }

    private static boolean isRandom(String qualifiedName) {
        return qualifiedName.equals("java.util.Random");
    }

    private boolean isTestClassName(@NotNull String methodName) {
        return (methodName = methodName.toLowerCase()).contains("test") || methodName.contains("benchmark") || methodName.contains("assert");
    }
}

