/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.helpers.TreeIterator;
import com.pvsstudio.helpers.TreeNode;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.utility.GeneralUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtVariableReference;

public class V6108
extends PvsStudioRule {
    private final PvsStudioRule.Pattern level2;
    private final PvsStudioRule.Pattern level3;

    public V6108() {
        PvsStudioRule.PatternBuilder builder = new PvsStudioRule.PatternBuilder(this).setMessage("Do not use real-type variables in 'for' loop counters.").setCwe(834).setSastId("CERT-NUM09-J");
        this.level2 = builder.setLevel(WarningLevel.LEVEL_2).build();
        this.level3 = builder.setLevel(WarningLevel.LEVEL_3).build();
    }

    @Override
    public final void visitCtFor(CtFor loop) {
        LoopMembers members = new LoopMembers(loop);
        if (!(members.areMembersComplete() && members.areInitCorrect() && members.areAddOrSubtractCounters() && members.areCountersOfRealType())) {
            return;
        }
        if (members.areAllValuesPredictable()) {
            this.level2.add((CtElement)loop, new Object[0]);
        } else {
            this.level3.add((CtElement)loop, new Object[0]);
        }
    }

    private static class LoopMembers {
        private final List<CtStatement> init;
        private final List<CtStatement> update;
        private final CtExpression<Boolean> condition;

        public LoopMembers(CtFor loop) {
            this.init = loop.getForInit();
            this.update = loop.getForUpdate();
            this.condition = loop.getExpression();
        }

        public boolean areMembersComplete() {
            return this.init != null && !this.init.isEmpty() && this.update != null && !this.update.isEmpty() && this.condition != null;
        }

        public boolean areInitCorrect() {
            for (CtStatement statement : this.init) {
                if (statement instanceof CtLocalVariable || statement instanceof CtAssignment) continue;
                return false;
            }
            return true;
        }

        private boolean areAddOrSubtractCounters() {
            for (CtStatement operator : this.update) {
                UnaryOperatorKind kind;
                if (operator instanceof CtUnaryOperator && ((kind = ((CtUnaryOperator)operator).getKind()) == UnaryOperatorKind.POSTINC || kind == UnaryOperatorKind.POSTDEC || kind == UnaryOperatorKind.PREINC || kind == UnaryOperatorKind.PREDEC)) {
                    return true;
                }
                if (operator instanceof CtOperatorAssignment) {
                    kind = ((CtOperatorAssignment)operator).getKind();
                } else {
                    if (!(operator instanceof CtAssignment) || !(((CtAssignment)operator).getAssignment() instanceof CtBinaryOperator)) continue;
                    kind = ((CtBinaryOperator)((CtAssignment)operator).getAssignment()).getKind();
                }
                if (kind != BinaryOperatorKind.MINUS && kind != BinaryOperatorKind.PLUS) continue;
                return true;
            }
            return false;
        }

        public boolean areCountersOfRealType() {
            for (CtTypedElement type : this.init.stream().filter(CtTypedElement.class::isInstance).map(CtTypedElement.class::cast).collect(Collectors.toUnmodifiableList())) {
                String stringType = type.getType().getSimpleName();
                if (!Objects.equals(stringType.toLowerCase(), "float") && !Objects.equals(stringType.toLowerCase(), "double")) continue;
                return true;
            }
            return false;
        }

        private TreeNode createDeclarationFinderNode(CtCodeElement el) {
            return new TreeNode(el){

                @Override
                public List<CtCodeElement> getChildrenHook() {
                    CtCodeElement el = this.getElement();
                    CtExpression expr = null;
                    if (el instanceof CtLocalVariable) {
                        expr = ((CtLocalVariable)el).getDefaultExpression();
                    } else if (el instanceof CtAssignment) {
                        expr = ((CtAssignment)el).getAssignment();
                    } else if (el instanceof CtVariableRead) {
                        expr = Optional.of((CtVariableRead)el).map(CtVariableAccess::getVariable).map(CtVariableReference::getDeclaration).map(CtVariable::getDefaultExpression).orElse(null);
                    }
                    return expr != null ? Collections.singletonList(expr) : null;
                }
            };
        }

        public boolean areAllValuesPredictable() {
            MutableBoolean res = new MutableBoolean(true);
            LinkedList<Object> counterReferences = new LinkedList<Object>();
            BiFunction<CtCodeElement, TreeIterator, Boolean> statementCheck = (element, iterator) -> {
                res.setValue(!iterator.isTerminalNode() || element instanceof CtLiteral);
                return res.getValue();
            };
            BiFunction<CtCodeElement, TreeIterator, Boolean> statementNoCounterCheck = (element, iterator) -> {
                res.setValue((Boolean)statementCheck.apply((CtCodeElement)element, (TreeIterator)iterator) != false || element instanceof CtVariableRead && counterReferences.stream().anyMatch(x -> RulesUtils.equals((CtElement)x, (CtElement)((CtVariableRead)element).getVariable())));
                return res.getValue();
            };
            for (CtStatement statement : this.init) {
                CtVariableWrite variableWrite;
                if (statement instanceof CtLocalVariable) {
                    counterReferences.add(((CtLocalVariable)statement).getReference());
                } else if (statement instanceof CtAssignment && (variableWrite = GeneralUtils.safeCast(((CtAssignment)statement).getAssigned(), CtVariableWrite.class)) != null) {
                    counterReferences.add(variableWrite.getVariable());
                }
                TreeIterator.forEach((CtCodeElement)statement, this::createDeclarationFinderNode, statementCheck);
                if (res.getValue().booleanValue()) continue;
                return false;
            }
            for (CtStatement operator : this.update) {
                if (operator instanceof CtAssignment) {
                    TreeIterator.forEach((CtCodeElement)operator, this::createDeclarationFinderNode, statementNoCounterCheck);
                } else if (!(operator instanceof CtUnaryOperator)) {
                    return false;
                }
                if (res.getValue().booleanValue()) continue;
                return false;
            }
            TreeIterator.forEach(this.condition, this::createDeclarationFinderNode, statementNoCounterCheck);
            return res.getValue();
        }
    }
}

