/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Map;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.declaration.CtElement;
import spoon.support.reflect.code.CtUnaryOperatorImpl;

public class V6107
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("The constant %s is being utilized. The resulting value could be inaccurate. Consider using %s.").setLevel(WarningLevel.LEVEL_3).setCwe(547).build();
    private static final byte MIN_STRING_LENGTH = 6;
    private static final byte MAX_STRING_LENGTH = 15;
    private static final byte BIG_ARRAY_SIZE = 10;
    private static final Map<String, String> constsMap = Map.ofEntries(Map.entry("Math.PI", "3.141592653589793"), Map.entry("Math.PI * 2", "6.283185307179586"), Map.entry("Math.E", "2.718281828459045"), Map.entry("Math.log(Math.E) / Math.log(2)", "1.4426950408889634"), Map.entry("Math.log10(Math.E)", "0.4342944819032518"), Map.entry("Math.log(2)", "0.6931471805599453"), Map.entry("Math.log(10)", "2.302585092994046"), Map.entry("Math.PI / 2", "1.5707963267948966"), Map.entry("Math.PI / 4", "0.7853981633974483"), Map.entry("1 / Math.PI", "0.3183098861837907"), Map.entry("2 / Math.PI", "0.6366197723675814"), Map.entry("2 / Math.sqrt(Math.PI)", "1.1283791670955126"), Map.entry("Math.sqrt(2)", "1.4142135623730951"), Map.entry("Math.sqrt(0.5)", "0.7071067811865476"), Map.entry("180 / Math.PI or Math.toDegrees(...)", "57.29577951308232"), Map.entry("Math.PI / 180 or Math.toRadians(...)", "0.017453292519943295"));

    public final <T> void visitCtLiteral(CtLiteral<T> literal) {
        if (this.isInsideTestSources((CtElement)literal)) {
            return;
        }
        if (!literal.getType().getSimpleName().equals("double")) {
            return;
        }
        String value = literal.getValue().toString();
        if (value.charAt(0) == '.') {
            value = "0".concat(value);
        }
        if (value.length() < 6 || value.length() > 15) {
            return;
        }
        if (this.isInBigArray(literal).booleanValue()) {
            return;
        }
        int substringLength = Character.isLetter(value.charAt(value.length() - 1)) ? value.length() - 2 : value.length() - 1;
        String compareString = value.substring(0, substringLength);
        for (Map.Entry<String, String> pair : constsMap.entrySet()) {
            if (!pair.getValue().startsWith(compareString)) continue;
            this.rule.add((CtElement)literal, value, pair.getKey());
        }
    }

    private <T> Boolean isInBigArray(CtLiteral<T> literal) {
        CtElement element = literal.getParent();
        if (element instanceof CtUnaryOperatorImpl) {
            element = element.getParent();
        }
        while (element instanceof CtNewArray) {
            if (((CtNewArray)element).getElements().size() > 10) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }
}

