/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;

public class V6106
extends PvsStudioRule {
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder().setMessage("Casting expression to %s type before implicitly casting it to other type may be excessive or incorrect.").setCwe(704).setLevel(WarningLevel.LEVEL_3).build();
    private Boolean isTest = null;

    private boolean isTestSource(CtElement e) {
        if (this.isTest == null) {
            this.isTest = this.isInsideTestSources(e);
        }
        return this.isTest;
    }

    @Override
    public void clear() {
        super.clear();
        this.isTest = null;
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        List invArguments = inv.getArguments();
        if (invArguments.isEmpty()) {
            return;
        }
        ArrayList executableTypeRef = new ArrayList(inv.getExecutable().getParameters());
        if (invArguments.size() != executableTypeRef.size()) {
            return;
        }
        String executableName = inv.getExecutable().getSimpleName();
        if (executableName.startsWith("write") || executableName.startsWith("valueOf") || executableName.startsWith("indexOf") || executableName.startsWith("lastIndexOf")) {
            return;
        }
        if (inv.getTarget() != null && inv.getTarget().getType() != null && Objects.equals(inv.getTarget().getType().getQualifiedName(), "java.util.zip.Checksum")) {
            return;
        }
        for (int i = 0; i < invArguments.size(); ++i) {
            CtTypeReference expectedTypeRef = (CtTypeReference)executableTypeRef.get(i);
            if (!expectedTypeRef.isPrimitive() && !JavaTypes.isWrapperType(expectedTypeRef)) continue;
            this.startAnalysis(expectedTypeRef, (CtExpression)invArguments.get(i));
        }
    }

    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.startAnalysis(localVariable.getType(), localVariable.getAssignment());
    }

    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        CtAssignment expression = (CtAssignment)variableWrite.getParent(CtAssignment.class);
        if (expression != null) {
            this.startAnalysis(expression.getAssigned().getType(), expression.getAssignment());
        }
    }

    public void startAnalysis(CtTypeReference<?> expectedTypeRef, CtExpression<?> assignmentExp) {
        boolean typeCastRefIsChar;
        String typeCastName;
        boolean isPrimitiveOrWrapperExpectedType;
        if (expectedTypeRef == null || assignmentExp == null || this.isTestSource((CtElement)assignmentExp) || assignmentExp instanceof CtLambda || assignmentExp instanceof CtLiteral || assignmentExp.getTypeCasts().isEmpty()) {
            return;
        }
        if (assignmentExp instanceof CtUnaryOperator && ((CtUnaryOperator)assignmentExp).getOperand() instanceof CtLiteral) {
            return;
        }
        CtTypeReference<?> typeCastRef = RulesUtils.getType(assignmentExp);
        if (typeCastRef == null || typeCastRef instanceof CtTypeParameterReference || typeCastRef.isGenerics()) {
            return;
        }
        if (!typeCastRef.isPrimitive() && !JavaTypes.isWrapperType(typeCastRef)) {
            return;
        }
        boolean bl = isPrimitiveOrWrapperExpectedType = expectedTypeRef.isPrimitive() || JavaTypes.isWrapperType(expectedTypeRef);
        if (isPrimitiveOrWrapperExpectedType && JavaTypes.isIdenticalTypes(expectedTypeRef, typeCastRef)) {
            return;
        }
        String expectedTypeName = this.getTypeSimpleName(expectedTypeRef);
        if (Objects.equals(expectedTypeName, typeCastName = this.getTypeSimpleName(typeCastRef))) {
            return;
        }
        if (assignmentExp instanceof CtBinaryOperator && this.isLimitValueMask((CtBinaryOperator)assignmentExp)) {
            return;
        }
        CtTypeReference assignmentExpTypeRef = assignmentExp.getType();
        if (JavaTypes.isFloatType(expectedTypeRef) && JavaTypes.isFloatType(assignmentExpTypeRef) && JavaTypes.isIntegerType(typeCastRef)) {
            return;
        }
        boolean bl2 = typeCastRefIsChar = Objects.equals(typeCastRef.getSimpleName(), "char") || Objects.equals(typeCastRef.getSimpleName(), "Character");
        if (JavaTypes.isIntegerType(expectedTypeRef) && JavaTypes.isIntegerType(assignmentExpTypeRef) && typeCastRefIsChar) {
            return;
        }
        String expectedQualifiedName = expectedTypeRef.getQualifiedName();
        if (expectedQualifiedName != null && (expectedQualifiedName.equals("java.lang.Object") || expectedQualifiedName.equals("java.lang.Number"))) {
            return;
        }
        this.pattern.add((CtElement)typeCastRef, typeCastName);
    }

    private String getTypeSimpleName(CtTypeReference<?> typeCastRef) {
        if (typeCastRef instanceof CtArrayTypeReference) {
            return ((CtArrayTypeReference)typeCastRef).getArrayType().getSimpleName();
        }
        return typeCastRef.getSimpleName();
    }

    private boolean isLimitValueMask(CtBinaryOperator<?> binaryOperator) {
        Object value;
        CtExpression operand = binaryOperator.getLeftHandOperand();
        if (!(operand instanceof CtLiteral)) {
            operand = binaryOperator.getRightHandOperand();
        }
        if (operand instanceof CtLiteral && (value = ((CtLiteral)operand).getValue()) instanceof Integer) {
            return Objects.equals(value, 255);
        }
        return false;
    }

    public static final class JavaTypes {
        private static final List<String> primitiveTypes = Arrays.asList("byte", "short", "int", "long", "float", "double", "boolean", "char");
        private static final List<String> wrapperTypes = Arrays.asList("Byte", "Short", "Integer", "Long", "Float", "Double", "Boolean", "Character");
        private static final List<String> integerTypes = Arrays.asList("byte", "Byte", "short", "Short", "int", "Integer", "long", "Long");
        private static final List<String> floatTypes = Arrays.asList("float", "Float", "double", "Double");

        public static boolean isWrapperType(CtTypeReference<?> type) {
            return type != null && wrapperTypes.contains(type.getSimpleName());
        }

        public static boolean isFloatType(CtTypeReference<?> type) {
            return type != null && floatTypes.contains(type.getSimpleName());
        }

        public static boolean isIntegerType(CtTypeReference<?> type) {
            return type != null && integerTypes.contains(type.getSimpleName());
        }

        public static boolean isIdenticalTypes(CtTypeReference<?> type1, CtTypeReference<?> type2) {
            if (type1 == null || type2 == null) {
                return false;
            }
            if (!type1.isPrimitive() && !type2.isPrimitive()) {
                return false;
            }
            String typeName1 = type1.getSimpleName();
            int index1 = type1.isPrimitive() ? primitiveTypes.indexOf(typeName1) : wrapperTypes.indexOf(typeName1);
            String typeName2 = type2.getSimpleName();
            int index2 = type2.isPrimitive() ? primitiveTypes.indexOf(typeName2) : wrapperTypes.indexOf(typeName2);
            return index1 == index2 && index1 != -1;
        }
    }
}

