/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;

public class V6105
extends PvsStudioRule {
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder(this).setMessage("Consider inspecting the loop expression. It is possible that different variables are used inside initializer and iterator.").setLevel(WarningLevel.LEVEL_2).setCwe(190).build();

    @Override
    public void visitCtFor(CtFor forLoop) {
        BinaryOperatorKind parentBinaryOperator;
        CtExpression assignment;
        BinaryOperatorKind binaryKind;
        UnaryOperatorKind updateKind;
        CtExpression updateVariable;
        List updateList = forLoop.getForUpdate();
        if (updateList == null || updateList.size() != 1) {
            return;
        }
        CtStatement updateStatement = (CtStatement)updateList.get(0);
        if (updateStatement instanceof CtUnaryOperator) {
            updateVariable = ((CtUnaryOperator)updateStatement).getOperand();
            updateKind = ((CtUnaryOperator)updateList.get(0)).getKind();
        } else if (updateStatement instanceof CtOperatorAssignment) {
            CtOperatorAssignment operatorAssignment = (CtOperatorAssignment)updateStatement;
            binaryKind = operatorAssignment.getKind();
            updateKind = this.binaryToUnary(binaryKind);
            updateVariable = operatorAssignment.getAssigned();
        } else if (updateStatement instanceof CtAssignment) {
            CtAssignment assignment2 = (CtAssignment)updateStatement;
            binaryKind = Optional.of(assignment2.getAssignment()).filter(CtBinaryOperator.class::isInstance).map(CtBinaryOperator.class::cast).map(CtBinaryOperator::getKind).orElse(null);
            if (binaryKind == null) {
                return;
            }
            updateKind = this.binaryToUnary(binaryKind);
            updateVariable = assignment2.getAssigned();
        } else {
            return;
        }
        if (!(updateVariable instanceof CtVariableAccess)) {
            return;
        }
        String updateVarName = ((CtVariableAccess)updateVariable).getVariable().getSimpleName();
        List initList = forLoop.getForInit();
        if (initList == null || initList.size() != 1) {
            return;
        }
        CtStatement initStatement = (CtStatement)initList.get(0);
        if (!(initStatement instanceof CtLocalVariable) && !(initStatement instanceof CtAssignment)) {
            return;
        }
        if (initStatement instanceof CtLocalVariable) {
            if (Objects.equals(((CtLocalVariable)initStatement).getSimpleName(), updateVarName)) {
                return;
            }
            assignment = ((CtLocalVariable)initStatement).getAssignment();
        } else {
            if (this.containsVarName(((CtAssignment)initStatement).getAssigned(), updateVarName)) {
                return;
            }
            assignment = ((CtAssignment)initStatement).getAssignment();
        }
        boolean updateVarContainsInInit = false;
        if (assignment instanceof CtVariableAccess && this.containsVarName(assignment, updateVarName)) {
            updateVarContainsInInit = true;
        } else if (assignment instanceof CtBinaryOperator && this.containsVarName(assignment, updateVarName)) {
            return;
        }
        CtExpression expression = forLoop.getExpression();
        if (!(expression instanceof CtBinaryOperator)) {
            return;
        }
        List<CtBinaryOperator<?>> binaryOperators = this.getBinaryContainsVar((CtBinaryOperator)expression, updateVarName);
        if (binaryOperators.isEmpty() && !updateVarContainsInInit || binaryOperators.size() > 1) {
            return;
        }
        if (binaryOperators.isEmpty()) {
            this.pattern.add((CtElement)forLoop, new Object[0]);
            return;
        }
        CtBinaryOperator<?> binaryExp = binaryOperators.get(0);
        BinaryOperatorKind binaryOperatorKind = binaryExp.getKind();
        if (binaryExp.getParent() instanceof CtBinaryOperator && (parentBinaryOperator = ((CtBinaryOperator)binaryExp.getParent()).getKind()) != BinaryOperatorKind.AND && parentBinaryOperator != BinaryOperatorKind.OR) {
            binaryOperatorKind = ((CtBinaryOperator)binaryExp.getParent()).getKind();
        }
        boolean binaryExpIsLessOrEquals = binaryOperatorKind == BinaryOperatorKind.LE || binaryOperatorKind == BinaryOperatorKind.LT;
        boolean binaryExpIsGreatOrEquals = binaryOperatorKind == BinaryOperatorKind.GE || binaryOperatorKind == BinaryOperatorKind.GT;
        boolean updateVarContainsInLeftExp = this.containsVarName(binaryExp.getLeftHandOperand(), updateVarName);
        boolean updateVarContainsInRightExp = this.containsVarName(binaryExp.getRightHandOperand(), updateVarName);
        boolean updateVarIsInc = updateKind == UnaryOperatorKind.PREINC || updateKind == UnaryOperatorKind.POSTINC;
        boolean updateVarIsDec = updateKind == UnaryOperatorKind.PREDEC || updateKind == UnaryOperatorKind.POSTDEC;
        boolean isZeroInit = false;
        if (initStatement instanceof CtLocalVariable) {
            IntegerVirtualValue initValue = this.getValue((CtElement)((CtLocalVariable)initStatement).getAssignment()).toInteger();
            boolean bl = isZeroInit = initValue != null && Objects.equals(initValue.toString(), "0");
        }
        if (isZeroInit && binaryExpIsGreatOrEquals && updateVarContainsInLeftExp && updateVarIsDec || !isZeroInit && binaryExpIsLessOrEquals && updateVarContainsInLeftExp && updateVarIsInc || isZeroInit && binaryExpIsLessOrEquals && updateVarContainsInRightExp && updateVarIsDec || !isZeroInit && binaryExpIsGreatOrEquals && updateVarContainsInRightExp && updateVarIsInc) {
            return;
        }
        if (isZeroInit && binaryOperatorKind == BinaryOperatorKind.NE && updateVarContainsInLeftExp && updateVarIsDec) {
            return;
        }
        this.pattern.add((CtElement)forLoop, new Object[0]);
    }

    private boolean containsVarName(CtExpression<?> expression, String name) {
        if (expression instanceof CtVariableAccess) {
            return Objects.equals(((CtVariableAccess)expression).getVariable().getSimpleName(), name);
        }
        if (expression instanceof CtBinaryOperator) {
            return this.containsVarName(((CtBinaryOperator)expression).getLeftHandOperand(), name) || this.containsVarName(((CtBinaryOperator)expression).getRightHandOperand(), name);
        }
        return false;
    }

    public List<CtBinaryOperator<?>> getBinaryContainsVar(CtBinaryOperator<?> binaryOperator, String name) {
        CtExpression rightExp;
        ArrayList binaryList = new ArrayList();
        CtExpression leftExp = binaryOperator.getLeftHandOperand();
        if (leftExp instanceof CtBinaryOperator) {
            binaryList.addAll(this.getBinaryContainsVar((CtBinaryOperator)leftExp, name));
        }
        if ((rightExp = binaryOperator.getRightHandOperand()) instanceof CtBinaryOperator) {
            binaryList.addAll(this.getBinaryContainsVar((CtBinaryOperator)rightExp, name));
        }
        if (!(leftExp instanceof CtBinaryOperator) && !(rightExp instanceof CtBinaryOperator) && (this.containsVarName(leftExp, name) || this.containsVarName(rightExp, name))) {
            binaryList.add(binaryOperator);
        }
        return binaryList;
    }

    public UnaryOperatorKind binaryToUnary(BinaryOperatorKind binaryKind) {
        switch (binaryKind) {
            case MUL: 
            case PLUS: {
                return UnaryOperatorKind.POSTINC;
            }
            case MOD: 
            case DIV: 
            case MINUS: {
                return UnaryOperatorKind.POSTDEC;
            }
        }
        return null;
    }
}

