/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtElement;

public class V6104
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("A pattern was detected: (%1$s) %2$s ((%1$s) %3$s ...). The expression is excessive or contains a logical error.").setLevel(WarningLevel.LEVEL_2).build();
    private static final Map<BinaryOperatorKind, BinaryOperatorKind> mapAntiLogicalOperators = new HashMap<BinaryOperatorKind, BinaryOperatorKind>(){
        {
            this.put(BinaryOperatorKind.AND, BinaryOperatorKind.OR);
            this.put(BinaryOperatorKind.OR, BinaryOperatorKind.AND);
            this.put(BinaryOperatorKind.BITAND, BinaryOperatorKind.BITOR);
            this.put(BinaryOperatorKind.BITOR, BinaryOperatorKind.BITAND);
        }
    };

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        BinaryOperatorKind antiOp = mapAntiLogicalOperators.get(operator.getKind());
        if (antiOp == null) {
            return;
        }
        CtExpression<?> suspiciousExpr = this.applyRule(operator.getLeftHandOperand(), operator.getRightHandOperand(), operator.getKind(), antiOp);
        if (suspiciousExpr == null) {
            return;
        }
        if (this.isAnySubExprModifyValue((CtExpression<?>)operator, suspiciousExpr)) {
            return;
        }
        this.rule.add((CtElement)suspiciousExpr, suspiciousExpr, RulesUtils.getOperatorText(operator.getKind()), RulesUtils.getOperatorText(antiOp));
    }

    private CtExpression<?> applyRule(CtExpression<?> left, CtExpression<?> right, BinaryOperatorKind firstOp, BinaryOperatorKind secondOp) {
        CtBinaryOperator ctBinaryOperator;
        if (left instanceof CtBinaryOperator && (ctBinaryOperator = (CtBinaryOperator)left).getKind() == firstOp) {
            CtExpression<?> suspicious = this.applyRule(ctBinaryOperator.getLeftHandOperand(), right, firstOp, secondOp);
            if (suspicious != null) {
                return suspicious;
            }
            return this.applyRule(ctBinaryOperator.getRightHandOperand(), right, firstOp, secondOp);
        }
        if (right instanceof CtBinaryOperator && (ctBinaryOperator = (CtBinaryOperator)right).getKind() == firstOp) {
            CtExpression<?> suspicious = this.applyRule(ctBinaryOperator.getLeftHandOperand(), left, firstOp, secondOp);
            if (suspicious != null) {
                return suspicious;
            }
            return this.applyRule(ctBinaryOperator.getRightHandOperand(), left, firstOp, secondOp);
        }
        CtExpression<?> suspiciousExpr = this.findSuspiciousExpr(left, right, secondOp);
        if (suspiciousExpr != null) {
            return suspiciousExpr;
        }
        return this.findSuspiciousExpr(right, left, secondOp);
    }

    private CtExpression<?> findSuspiciousExpr(CtExpression<?> leftExpr, CtExpression<?> rightExpr, BinaryOperatorKind secondOp) {
        if (!(rightExpr instanceof CtBinaryOperator)) {
            return null;
        }
        CtBinaryOperator rightBinary = (CtBinaryOperator)rightExpr;
        if (rightBinary.getKind() != secondOp) {
            return null;
        }
        if (RulesUtils.equals(leftExpr, (CtElement)rightBinary.getLeftHandOperand())) {
            return rightBinary.getLeftHandOperand();
        }
        if (RulesUtils.equals(leftExpr, (CtElement)rightBinary.getRightHandOperand())) {
            return rightBinary.getRightHandOperand();
        }
        return null;
    }

    private boolean isAnySubExprModifyValue(CtExpression<?> expression, CtExpression<?> suspiciousExpr) {
        List<CtExpression<?>> subExpressions = this.getSubExpressions(expression, suspiciousExpr);
        ArrayList indexes = new ArrayList();
        IntStream.range(0, subExpressions.size()).forEach(index -> {
            if (RulesUtils.equals((CtElement)subExpressions.get(index), (CtElement)suspiciousExpr)) {
                indexes.add(index);
            }
        });
        if (indexes.isEmpty()) {
            return true;
        }
        int start = (Integer)indexes.get(0);
        int end = (Integer)indexes.get(indexes.size() - 1);
        if (end <= start) {
            return true;
        }
        return subExpressions.subList(start, end).stream().anyMatch(it -> RulesUtils.isModifyValue(it, this.getDataFlow()));
    }

    private List<CtExpression<?>> getSubExpressions(CtExpression<?> expression, CtExpression<?> suspiciousExpr) {
        ArrayList expressions = new ArrayList();
        if (expression instanceof CtBinaryOperator) {
            CtBinaryOperator binOp = (CtBinaryOperator)expression;
            if (binOp.getKind() == BinaryOperatorKind.OR || binOp.getKind() == BinaryOperatorKind.AND || binOp.getKind() == BinaryOperatorKind.BITOR || binOp.getKind() == BinaryOperatorKind.BITAND || !RulesUtils.isBooleanOrBoxed(binOp)) {
                if (RulesUtils.equals((CtElement)binOp, suspiciousExpr)) {
                    expressions.add((CtExpression<?>)binOp);
                } else {
                    expressions.addAll(this.getSubExpressions(binOp.getLeftHandOperand(), suspiciousExpr));
                    expressions.addAll(this.getSubExpressions(binOp.getRightHandOperand(), suspiciousExpr));
                }
            } else {
                expressions.add((CtExpression<?>)binOp);
            }
        } else {
            expressions.add(expression);
        }
        return expressions;
    }
}

