/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Objects;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6103
extends PvsStudioRule {
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder(this).setMessage("Ignored InterruptedException could lead to delayed thread shutdown.").setLevel(WarningLevel.LEVEL_3).setCwe(391).build();

    public void visitCtCatch(CtCatch catchBlock) {
        if (catchBlock.getParameter().getType() == null) {
            return;
        }
        if (catchBlock.getParameter().getMultiTypes().size() != 1) {
            return;
        }
        if (!Objects.equals(catchBlock.getParameter().getType().getQualifiedName(), "java.lang.InterruptedException")) {
            return;
        }
        if (this.isInsideTestSources((CtElement)catchBlock)) {
            return;
        }
        for (CtComment ctComment : this.getComments((CtElement)catchBlock)) {
            String content = ctComment.getContent().toLowerCase();
            if (!content.contains("ignore") && !content.contains("nothing") && !content.contains("expected") && !content.contains("interrupt")) continue;
            return;
        }
        String parameterName = catchBlock.getParameter().getSimpleName();
        if (parameterName.toLowerCase().contains("ignore") || parameterName.toLowerCase().contains("expected")) {
            return;
        }
        for (CtAbstractInvocation invocation : catchBlock.getElements((Filter)new TypeFilter(CtAbstractInvocation.class))) {
            if (!this.containsParameter(invocation.getArguments(), parameterName)) continue;
            return;
        }
        if (catchBlock.getElements((Filter)new TypeFilter(CtThrow.class)).stream().map(throwElement -> throwElement.getThrownExpression().getType()).anyMatch(type -> type == null || Objects.equals(type.getQualifiedName(), "java.lang.InterruptedException"))) {
            return;
        }
        if (this.containsInterruptCall(catchBlock.getElements((Filter)new TypeFilter(CtInvocation.class)))) {
            return;
        }
        CtBlock ctBlock = ((CtTry)catchBlock.getParent(CtTry.class)).getFinalizer();
        if (ctBlock != null && this.containsInterruptCall(ctBlock.getElements((Filter)new TypeFilter(CtInvocation.class)))) {
            return;
        }
        CtTry parentTryBlock = (CtTry)((CtTry)catchBlock.getParent(CtTry.class)).getParent(CtTry.class);
        if (parentTryBlock != null && parentTryBlock.getCatchers() != null && parentTryBlock.getFinalizer() != null && this.containsInterruptCall(parentTryBlock.getFinalizer().getElements((Filter)new TypeFilter(CtInvocation.class)))) {
            return;
        }
        this.pattern.add((CtElement)catchBlock.getParameter(), new Object[0]);
    }

    private boolean containsInterruptCall(List<CtInvocation<?>> invocations) {
        for (CtInvocation<?> invocation : invocations) {
            CtTypeReference declaringType = invocation.getExecutable().getDeclaringType();
            if (declaringType == null || !Objects.equals(declaringType.getQualifiedName(), "java.lang.Thread") || !Objects.equals(invocation.getExecutable().getSimpleName(), "interrupt")) continue;
            return true;
        }
        return false;
    }

    private boolean containsParameter(List<CtExpression<?>> expressionList, String parameterName) {
        for (CtExpression<?> expression : expressionList) {
            if (expression instanceof CtVariableRead) {
                if (!Objects.equals(((CtVariableRead)expression).getVariable().getSimpleName(), parameterName)) continue;
                return true;
            }
            if (!(expression instanceof CtConstructorCall)) continue;
            List variables = ((CtConstructorCall)expression).getArguments();
            return this.containsParameter(variables, parameterName);
        }
        return false;
    }
}

