/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.google.common.collect.Sets;
import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.TypeClassification;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6102
extends PvsStudioRule {
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder().setMessage("Inconsistent synchronization of the '%s' field. Consider synchronizing the field on all usages.").setCwe(662).setSecId("SEC-SYNCHRONIZATION").build();
    private static final int MAX_USE_WITHOUT_SYNCHRO = 3;
    private static final int SAFE_PERCENT_OF_NON_SYNCHRO_USES = 66;
    private static final int PERCENT_FOR_UP_WARNING = 85;
    private static final List<String> THREAD_SAFE = List.of("java.util.logging.Logger", "org.apache.logging.log4j.Logger", "org.slf4j.Logger", "java.util.Vector", "java.util.Stack", "java.util.Hashtable");
    private Set<CtMethod<?>> methodsWithSynchroBlock = Sets.newIdentityHashSet();

    private void clearMethodsWithSynchroBlock() {
        this.methodsWithSynchroBlock = Sets.newIdentityHashSet();
    }

    public void visitCtSynchronized(CtSynchronized synchro) {
        this.methodsWithSynchroBlock.add((CtMethod)synchro.getParent(CtMethod.class));
    }

    @Override
    public void clear() {
        super.clear();
        this.clearMethodsWithSynchroBlock();
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        if (this.isInsideTestSources((CtElement)ctClass)) {
            return;
        }
        boolean hasSynchroMethods = ctClass.getMethods().stream().anyMatch(method -> method.hasModifier(ModifierKind.SYNCHRONIZED));
        if (!hasSynchroMethods && this.methodsWithSynchroBlock.isEmpty()) {
            return;
        }
        ArrayList<AnalyzedField> fieldsForAnalysis = new ArrayList<AnalyzedField>();
        for (CtField field : ctClass.getFields()) {
            if (field.hasModifier(ModifierKind.VOLATILE) || this.isThreadSafeType(field) || this.isDefaultExprSynchroContext(field) || this.isStaticFinalImmutableType(field)) continue;
            fieldsForAnalysis.add(new AnalyzedField((CtElement)field));
        }
        this.removeFieldsSynchronizedInConstructor(ctClass, fieldsForAnalysis);
        if (fieldsForAnalysis.isEmpty()) {
            return;
        }
        for (CtMethod method2 : ctClass.getMethods()) {
            method2.getElements((Filter)new TypeFilter(CtFieldAccess.class)).forEach(element -> {
                AnalyzedField analyzedField = fieldsForAnalysis.stream().filter(field -> field.equalsElementName((CtElement)element)).filter(field -> element.getTarget() instanceof CtThisAccess || ((CtField)field.ctElement).isStatic()).findFirst().orElse(null);
                if (analyzedField != null) {
                    CtMethod parentMethod = (CtMethod)element.getParent(CtMethod.class);
                    if (parentMethod.hasModifier(ModifierKind.SYNCHRONIZED) && element.getVariable().isStatic() == method2.isStatic()) {
                        analyzedField.addSynchroMethod(method2);
                    } else if (this.methodsWithSynchroBlock.contains(parentMethod)) {
                        CtSynchronized parent = (CtSynchronized)element.getParent(CtSynchronized.class);
                        if (parent != null) {
                            if (element.getVariable().isStatic() && !this.isSynchronizedExpressionStatic(parent.getExpression())) {
                                analyzedField.addNonSynchroMethod(method2, (CtElement)element);
                                return;
                            }
                            if (element.getParent() instanceof CtSynchronized) {
                                analyzedField.addObjSynchroMethod(method2);
                            } else {
                                analyzedField.addSynchroMethod(method2);
                            }
                        } else {
                            analyzedField.addNonSynchroMethod(method2, (CtElement)element);
                        }
                    } else {
                        analyzedField.addNonSynchroMethod(method2, (CtElement)element);
                    }
                }
            });
        }
        for (AnalyzedField analyzedField : fieldsForAnalysis) {
            int percentSynchroUsage;
            int synchroCounter = analyzedField.getSynchroMethodsSize();
            int objSynchroCounter = analyzedField.getObjSynchroMethodsSize();
            int nonSynchroCounter = analyzedField.getNonSynchroMethodsSize();
            if (nonSynchroCounter == 0 || nonSynchroCounter > 3 || synchroCounter == 0 || (percentSynchroUsage = synchroCounter * 100 / (nonSynchroCounter + synchroCounter)) < 66) continue;
            WarningLevel level = WarningLevel.LEVEL_3;
            if (objSynchroCounter >= synchroCounter || percentSynchroUsage >= 85) {
                level = WarningLevel.LEVEL_2;
            }
            WarningAdapter warning = this.pattern.add(analyzedField.getElement(), ((CtField)analyzedField.getElement()).getSimpleName()).setLevel(level);
            for (CtElement nonSynchroElement : analyzedField.getNonSynchroElements()) {
                warning.addSourcePosition(nonSynchroElement, this.getModule());
            }
        }
        this.clearMethodsWithSynchroBlock();
    }

    private boolean isSynchronizedExpressionStatic(CtExpression<?> expression) {
        if (!(expression instanceof CtFieldAccess)) {
            return false;
        }
        CtFieldAccess fieldAccess = (CtFieldAccess)expression;
        return fieldAccess.getVariable().isStatic() || fieldAccess.getVariable().getType().getQualifiedName().equals("java.lang.Class");
    }

    private boolean isThreadSafeType(CtField<?> field) {
        if (field.getType() == null || field.getType().getPackage() == null) {
            return false;
        }
        String fieldPackage = field.getType().getPackage().getSimpleName();
        String fieldType = field.getType().getQualifiedName();
        return fieldPackage.startsWith("java.util.concurrent") || THREAD_SAFE.contains(fieldType);
    }

    private boolean isDefaultExprSynchroContext(CtField<?> field) {
        if (field.getDefaultExpression() instanceof CtInvocation) {
            CtExecutableReference executable = ((CtInvocation)field.getDefaultExpression()).getExecutable();
            if (executable.getDeclaringType() != null) {
                String qualifiedName = executable.getDeclaringType().getQualifiedName();
                return Objects.equals(qualifiedName, "java.util.Collections") && executable.getSimpleName().startsWith("synchronized");
            }
        } else if (field.getDefaultExpression() instanceof CtConstructorCall) {
            String signature = ((CtConstructorCall)field.getDefaultExpression()).getExecutable().getDeclaringType().getQualifiedName();
            return signature.startsWith("java.util.concurrent") || THREAD_SAFE.contains(signature);
        }
        return false;
    }

    private <T> void removeFieldsSynchronizedInConstructor(CtClass<?> parent, List<AnalyzedField> varForAnalysis) {
        for (CtConstructor constructor : parent.getConstructors()) {
            List ctFieldWrites = constructor.getElements(CtFieldWrite.class::isInstance);
            for (CtFieldWrite fieldWrite : ctFieldWrites) {
                String name;
                CtTypeReference typeReference;
                AnalyzedField analyzedField = varForAnalysis.stream().filter(field -> field.equalsElementName((CtElement)fieldWrite)).findFirst().orElse(null);
                if (analyzedField == null || !(fieldWrite.getParent() instanceof CtAssignment) || (typeReference = ((CtAssignment)fieldWrite.getParent()).getAssignment().getType()) == null || !(name = typeReference.getQualifiedName()).startsWith("java.util.concurrent") && !THREAD_SAFE.contains(name)) continue;
                varForAnalysis.remove(analyzedField);
            }
        }
    }

    private boolean isStaticFinalImmutableType(CtField<?> field) {
        if (field.isStatic() && field.isFinal()) {
            if (RulesUtils.isPrimitive(field)) {
                return true;
            }
            Annotation ann = this.getDataFlow().getTypeAnnotation((CtTypedElement<?>)field);
            return ann == null || ann.is(TypeClassification.Immutable);
        }
        return false;
    }

    private static class AnalyzedField {
        private final CtElement ctElement;
        private final Set<CtMethod<?>> synchroMethods = Sets.newIdentityHashSet();
        private final Set<CtMethod<?>> objSynchroMethods = Sets.newIdentityHashSet();
        private final Set<CtMethod<?>> nonSynchroMethods = Sets.newIdentityHashSet();
        private final List<CtElement> nonSynchroElements = new ArrayList<CtElement>();

        public AnalyzedField(CtElement ctElement) {
            this.ctElement = ctElement;
        }

        public CtElement getElement() {
            return this.ctElement;
        }

        public boolean equalsElementName(CtElement element) {
            return Objects.equals(((CtField)this.ctElement).getSimpleName(), ((CtFieldAccess)element).getVariable().getSimpleName());
        }

        public void addSynchroMethod(CtMethod<?> method) {
            this.synchroMethods.add(method);
        }

        public void addObjSynchroMethod(CtMethod<?> method) {
            if (this.objSynchroMethods.contains(method)) {
                return;
            }
            this.objSynchroMethods.add(method);
        }

        public void addNonSynchroMethod(CtMethod<?> method, CtElement ctElement) {
            if (this.nonSynchroMethods.contains(method)) {
                return;
            }
            this.nonSynchroElements.add(ctElement);
            this.nonSynchroMethods.add(method);
        }

        public int getSynchroMethodsSize() {
            return this.synchroMethods.size();
        }

        public int getObjSynchroMethodsSize() {
            return this.objSynchroMethods.size();
        }

        public int getNonSynchroMethodsSize() {
            return this.nonSynchroMethods.size();
        }

        public List<CtElement> getNonSynchroElements() {
            return this.nonSynchroElements;
        }
    }
}

