/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;

public class V6101
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(253).setSastId("CERT-EXP00-J").setLevel(WarningLevel.LEVEL_2);
    private final PvsStudioRule.Pattern suspiciousCmpNumber = this.ruleBuilder.setMessage("Expression '%1$s(....) %2$s %3$s' is incorrect. This method can return any %4$s value.").build();
    private final PvsStudioRule.Pattern suspiciousCmpNumberExtended = this.ruleBuilder.setMessage("Expression '%1$s(....) %2$s %3$s' is incorrect. This method can return any %4$s value. Consider using '%1$s(....) %5$s 0' instead.").build();
    private final PvsStudioRule.Pattern suspiciousCmpInv = this.ruleBuilder.setMessage("Expression '%1$s(....) %2$s %3$s(....)' is incorrect. These methods can return any value. Consider reviewing this code.").build();

    private boolean isCmpInvocation(CtElement element) {
        if (!(element instanceof CtInvocation)) {
            return false;
        }
        return this.annotationService.getAnnotations(element).contains((Annotation)FlagAnnotation.COMPARABLE);
    }

    private boolean isException(@NotNull CtInvocation<?> cmpInvocation) {
        CtTypeReference typeReference = cmpInvocation.getExecutable().getDeclaringType();
        if (typeReference == null) {
            return true;
        }
        if (this.isInsideTestSources((CtElement)cmpInvocation)) {
            return true;
        }
        if (typeReference.unbox() != typeReference) {
            return true;
        }
        String qualifiedName = typeReference.getQualifiedName();
        return qualifiedName.equals("java.math.BigDecimal") || qualifiedName.equals("java.math.BigInteger");
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        WarningAdapter warningAdapter;
        CtExpression comparedExpr;
        CtInvocation cmpInvocation;
        if (operator.getKind() != BinaryOperatorKind.EQ && operator.getKind() != BinaryOperatorKind.NE) {
            return;
        }
        boolean isLeft = true;
        if (!this.isCmpInvocation((CtElement)operator.getLeftHandOperand())) {
            if (this.isCmpInvocation((CtElement)operator.getRightHandOperand())) {
                isLeft = false;
            } else {
                return;
            }
        }
        CtInvocation ctInvocation = cmpInvocation = isLeft ? (CtInvocation)operator.getLeftHandOperand() : (CtInvocation)operator.getRightHandOperand();
        if (this.isException(cmpInvocation)) {
            return;
        }
        WarningLevel level = WarningLevel.LEVEL_2;
        if (cmpInvocation.getTarget() instanceof CtThisAccess) {
            if (cmpInvocation.getExecutable().isFinal()) {
                return;
            }
            level = level.decrease();
        }
        CtExpression ctExpression = comparedExpr = isLeft ? operator.getRightHandOperand() : operator.getLeftHandOperand();
        if (this.isCmpInvocation((CtElement)comparedExpr)) {
            warningAdapter = this.suspiciousCmpInv.add((CtElement)operator, cmpInvocation.getExecutable().getSimpleName(), RulesUtils.getOperatorText(operator.getKind()), ((CtInvocation)comparedExpr).getExecutable().getSimpleName());
        } else {
            String positiveNegative;
            int intValue;
            IntegerVirtualValue value = this.getValue((CtElement)comparedExpr).toInteger();
            if (value != null && value.isPrecise()) {
                intValue = value.min().toInt().get();
                if (intValue == 0) {
                    return;
                }
            } else {
                return;
            }
            String string = positiveNegative = intValue > 0 ? "positive" : "negative";
            if (operator.getKind() == BinaryOperatorKind.EQ) {
                warningAdapter = this.suspiciousCmpNumberExtended.add((CtElement)operator, cmpInvocation.getExecutable().getSimpleName(), RulesUtils.getOperatorText(operator.getKind()), intValue, positiveNegative, intValue > 0 ? ">" : "<");
            } else {
                if (intValue == 1 || intValue == -1) {
                    this.suspiciousCmpNumberExtended.add((CtElement)operator, cmpInvocation.getExecutable().getSimpleName(), RulesUtils.getOperatorText(operator.getKind()), intValue, positiveNegative, intValue == 1 ? "<=" : ">=").setLevel(level);
                    return;
                }
                warningAdapter = this.suspiciousCmpNumber.add((CtElement)operator, cmpInvocation.getExecutable().getSimpleName(), RulesUtils.getOperatorText(operator.getKind()), intValue, positiveNegative);
            }
        }
        warningAdapter.setLevel(level);
    }
}

