/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.Constraint;
import com.pvsstudio.core.JavaContext;
import com.pvsstudio.core.Result;
import com.pvsstudio.dataflow.MethodAnnotation;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;

public class V6100
extends PvsStudioRule {
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder().setMessage("An object is used as an argument to its own method. Consider checking the first actual argument of the '%s' method.").setCwe(688).build();

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        CtVariableReference argument;
        Annotation annotation;
        CtExpression target = inv.getTarget();
        if (target == null || inv.getArguments().size() != 1 || target instanceof CtThisAccess || target instanceof CtConstructorCall || target instanceof CtTypeAccess) {
            return;
        }
        CtExpression firstArgument = (CtExpression)inv.getArguments().get(0);
        if (firstArgument instanceof CtFieldRead && ((CtFieldRead)firstArgument).getVariable().getSimpleName().equals("class")) {
            return;
        }
        if (target instanceof CtAbstractInvocation && !(annotation = this.getMethodAnnotation((CtAbstractInvocation)target)).getPure()) {
            return;
        }
        if (!Objects.equals(firstArgument, target)) {
            return;
        }
        CtTypeReference classReference = inv.getExecutable().getDeclaringType();
        if (classReference != null && this.isExcludedPackages(classReference)) {
            return;
        }
        WarningLevel warningLevel = WarningLevel.LEVEL_2;
        if (this.isInsideTestSources((CtElement)inv)) {
            warningLevel = warningLevel.decrease();
        }
        if (firstArgument instanceof CtVariableRead && ((argument = ((CtVariableRead)firstArgument).getVariable()) instanceof CtParameterReference || argument instanceof CtLocalVariableReference) && this.isFirstArgumentHidesField((CtClass)inv.getParent(CtClass.class), argument.getSimpleName())) {
            warningLevel = warningLevel.increase();
        }
        if (warningLevel == WarningLevel.LEVEL_3) {
            return;
        }
        if (this.isContractFailure(inv)) {
            return;
        }
        this.pattern.add((CtElement)inv, inv.getExecutable().getSimpleName()).setLevel(warningLevel);
    }

    private boolean isFirstArgumentHidesField(@NotNull CtClass<?> ctClass, String firstArgumentName) {
        return ctClass.getFields().stream().anyMatch(field -> Objects.equals(field.getSimpleName(), firstArgumentName));
    }

    private boolean isExcludedPackages(@NotNull CtTypeReference<?> classReference) {
        String qualifiedName = classReference.getQualifiedName();
        return Objects.equals(qualifiedName, "java.util.Locale") || qualifiedName.startsWith("io.reactivex.") || qualifiedName.startsWith("org.reactivestreams.") || qualifiedName.contains(".math.") || qualifiedName.startsWith("math.");
    }

    private boolean isContractFailure(CtInvocation<?> inv) {
        MethodAnnotation annotation = this.getDataFlow().getMethodAnnotation(inv);
        if (annotation == null) {
            return false;
        }
        JavaContext context = annotation.getContext();
        if (context == null) {
            return false;
        }
        Result res = context.getContractResult();
        if (res == Result.Ok) {
            return false;
        }
        Optional<Constraint> contractType = context.getContractType();
        return contractType.isPresent() && contractType.get() == Constraint.NotEquals;
    }
}

