/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.internal.Pair;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6099
extends PvsStudioRule {
    private final PvsStudioRule.Pattern suboptimalIndexesPattern = new PvsStudioRule.PatternBuilder().setMessage("The initial value of the index in the nested loop equals '%s'. Consider using '%s + 1' instead.").setLevel(WarningLevel.LEVEL_3).setCwe(691).build();
    private static final List<BinaryOperatorKind> BINARY_OPERATOR_KINDS = Arrays.asList(BinaryOperatorKind.GT, BinaryOperatorKind.GE, BinaryOperatorKind.LT, BinaryOperatorKind.LE);

    @Override
    public void visitCtFor(CtFor innerFor) {
        if (innerFor.getExpression() == null || innerFor.getBody() == null) {
            return;
        }
        CtFor outerFor = RulesUtils.getParentBounded(innerFor.getParent(), innerFor.getParent((Filter)new TypeFilter(CtExecutable.class)), CtFor.class);
        if (outerFor == null || outerFor.getExpression() == null) {
            return;
        }
        if (!(outerFor.getExpression() instanceof CtBinaryOperator) || !(innerFor.getExpression() instanceof CtBinaryOperator)) {
            return;
        }
        Collection<String> modifiedVariablesInInnerFor = this.getModifiedVariables(innerFor);
        List arrayAccesses = innerFor.getBody().getElements((Filter)new TypeFilter(CtArrayAccess.class));
        List innerCounters = innerFor.getForInit().stream().filter(it -> it instanceof CtLocalVariable || it instanceof CtAssignment).map(it -> Pair.of((Object)((CtElement)it.getValueByRole(CtRole.ASSIGNMENT)), (Object)(it instanceof CtAssignment ? ((CtAssignment)it).getAssigned().toString() : ((CtLocalVariable)it).getSimpleName()))).filter(it -> Objects.nonNull(it.getLeft())).filter(it -> Objects.nonNull(it.getRight())).filter(a -> !modifiedVariablesInInnerFor.contains(a.getRight())).collect(Collectors.toList());
        if (innerCounters.isEmpty()) {
            return;
        }
        Collection<String> modifiedVariablesInOuterFor = this.getModifiedVariables(outerFor);
        Collection conditions = innerFor.getBody().getElements((Filter)new TypeFilter(CtBinaryOperator.class)).stream().filter(it -> Objects.equals(it.getKind(), BinaryOperatorKind.EQ) || Objects.equals(it.getKind(), BinaryOperatorKind.NE)).map(it -> it).collect(Collectors.toSet());
        for (String outerCounter : RulesUtils.getLoopCounters(outerFor)) {
            if (modifiedVariablesInOuterFor.contains(outerCounter)) continue;
            for (Pair pair : innerCounters) {
                CtElement innerCounterAssignment = (CtElement)pair.getLeft();
                String innerCounter = (String)pair.getRight();
                if (!Objects.equals(innerCounterAssignment.toString(), outerCounter)) continue;
                boolean countersComparing = this.countersComparingInCondition(conditions, innerCounter, outerCounter);
                boolean counterReferring = this.countersReferToOneArray(arrayAccesses, innerCounter, outerCounter);
                if (countersComparing || !counterReferring) continue;
                this.suboptimalIndexesPattern.add(innerCounterAssignment, innerCounterAssignment, innerCounterAssignment);
            }
        }
    }

    private Collection<String> getModifiedVariables(CtFor ctFor) {
        return ctFor.getBody().getElements((Filter)new TypeFilter(CtVariableWrite.class)).stream().map(it -> it.getVariable().getSimpleName()).collect(Collectors.toSet());
    }

    private List<CtBinaryOperator<?>> getBinaryOperator(CtElement expression, String counter) {
        return expression.getElements((Filter)new TypeFilter(CtVariableAccess.class)).stream().filter(it -> Objects.equals(it.toString(), counter)).map(CtElement::getParent).filter(CtBinaryOperator.class::isInstance).map(it -> (CtBinaryOperator)it).filter(it -> BINARY_OPERATOR_KINDS.contains(it.getKind())).collect(Collectors.toList());
    }

    private boolean isOppositeBinaryOperator(BinaryOperatorKind innerOperatorKind, BinaryOperatorKind outerOperatorKind) {
        return !((innerOperatorKind != BinaryOperatorKind.GE && innerOperatorKind != BinaryOperatorKind.GT || outerOperatorKind != BinaryOperatorKind.LE && outerOperatorKind != BinaryOperatorKind.LT) && (innerOperatorKind != BinaryOperatorKind.LE && innerOperatorKind != BinaryOperatorKind.LT || outerOperatorKind != BinaryOperatorKind.GE && outerOperatorKind != BinaryOperatorKind.GT));
    }

    private boolean countersComparingInCondition(Collection<CtBinaryOperator<?>> conditions, String innerCounter, String outerCounter) {
        return conditions.stream().anyMatch(condition -> {
            String left = condition.getLeftHandOperand().toString();
            String right = condition.getRightHandOperand().toString();
            return left.equals(innerCounter) && right.equals(outerCounter) || left.equals(outerCounter) && right.equals(innerCounter);
        });
    }

    private boolean countersReferToOneArray(Collection<CtArrayAccess<?, ?>> arrayAccesses, String innerCounter, String outerCounter) {
        List arrayAccessesInnerCounter = arrayAccesses.stream().filter(it -> Objects.equals(it.getIndexExpression().toString(), innerCounter)).map(CtTargetedExpression::getTarget).collect(Collectors.toList());
        List arrayAccessesOuterCounter = arrayAccesses.stream().filter(it -> Objects.equals(it.getIndexExpression().toString(), outerCounter)).map(CtTargetedExpression::getTarget).collect(Collectors.toList());
        return arrayAccessesInnerCounter.stream().anyMatch(arrayAccessesOuterCounter::contains);
    }

    private boolean sameCountersBound(CtBinaryOperator<?> innerLoopExpression, CtBinaryOperator<?> outerLoopExpression, String innerCounter, String outerCounter) {
        List<CtBinaryOperator<?>> innerOperators = this.getBinaryOperator((CtElement)innerLoopExpression, innerCounter);
        List<CtBinaryOperator<?>> outerOperators = this.getBinaryOperator((CtElement)outerLoopExpression, outerCounter);
        for (CtBinaryOperator<?> innerOperator : innerOperators) {
            CtExpression leftInnerOperand = innerOperator.getLeftHandOperand();
            CtExpression rightInnerOperand = innerOperator.getRightHandOperand();
            for (CtBinaryOperator<?> outerOperator : outerOperators) {
                CtExpression leftOuterOperand = outerOperator.getLeftHandOperand();
                CtExpression rightOuterOperand = outerOperator.getRightHandOperand();
                if (Objects.equals(innerOperator.getKind(), outerOperator.getKind())) {
                    return RulesUtils.equals((CtElement)leftInnerOperand, (CtElement)leftOuterOperand) || RulesUtils.equals((CtElement)rightInnerOperand, (CtElement)rightOuterOperand);
                }
                if (!this.isOppositeBinaryOperator(innerOperator.getKind(), outerOperator.getKind())) continue;
                return RulesUtils.equals((CtElement)rightInnerOperand, (CtElement)leftOuterOperand) || RulesUtils.equals((CtElement)leftInnerOperand, (CtElement)rightOuterOperand);
            }
        }
        return false;
    }
}

