/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.google.common.collect.Sets;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeReference;

public class V6098
extends PvsStudioRule {
    private static final Set<CtMethod<?>> objectTypeMethodsCanBeOverride = new TypeFactory().OBJECT.getTypeDeclaration().getMethods().stream().filter(m -> !m.isFinal() && !m.isStatic() && !m.isPrivate()).collect(Collectors.toSet());
    private final List<String> parametersPositionNames = Arrays.asList("first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "tenth");
    private final PvsStudioRule.Pattern wrongParameterType = new PvsStudioRule.PatternBuilder().setMessage("The '%s' method does not override the method from the %s class because the type of the %s parameter is inconsistent.").setLevel(WarningLevel.LEVEL_2).build();
    private final PvsStudioRule.Pattern parentMethodIsPackagePrivate = new PvsStudioRule.PatternBuilder().setMessage("The '%s' method does not override the method from the %s class because the method is private to another package.").setLevel(WarningLevel.LEVEL_2).build();
    private final PvsStudioRule.Pattern camelCaseTypo = new PvsStudioRule.PatternBuilder().setMessage("The '%s' method does not override the '%s' method from the %s class. It is possible there is a typo in a method's name.").setLevel(WarningLevel.LEVEL_2).build();
    private final Predicate<CtMethod<?>> methodsFilter = m -> !m.isStatic() && !m.isPrivate() && !m.isAbstract() && m.getSimpleName().length() > 2;
    private static final int DEPTH = 3;

    public <T> void visitCtInterface(CtInterface<T> ctInterface) {
        Set filteredParentMethods = this.collectInterfaces((CtType<?>)ctInterface, Sets.newIdentityHashSet(), 3).stream().flatMap(ctType -> this.getMethods((CtType<?>)ctType).filter(CtMethod::isDefaultMethod)).collect(Collectors.toCollection(Sets::newIdentityHashSet));
        Set filteredChildMethods = this.getMethods((CtType<?>)ctInterface).filter(CtMethod::isDefaultMethod).collect(Collectors.toCollection(Sets::newIdentityHashSet));
        this.apply(filteredChildMethods, filteredParentMethods);
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        Set filteredChildMethods = this.getMethods((CtType<?>)ctClass).filter(this.methodsFilter).collect(Collectors.toCollection(Sets::newIdentityHashSet));
        Set filteredParentMethods = this.collectAllSuperTypesAndInterfaces((CtType<?>)ctClass, Sets.newIdentityHashSet(), 3).stream().flatMap(type -> this.filterParentMethods(this.getMethods((CtType<?>)type)).stream()).collect(Collectors.toCollection(Sets::newIdentityHashSet));
        this.apply(filteredChildMethods, (Set<CtMethod<?>>)Sets.union((Set)filteredParentMethods, objectTypeMethodsCanBeOverride));
    }

    @NotNull
    private Stream<CtMethod<?>> getMethods(@NotNull CtType<?> type) {
        return type.getTypeMembers().stream().filter(CtMethod.class::isInstance).map(typeMember -> (CtMethod)typeMember);
    }

    @NotNull
    private Set<CtMethod<?>> filterParentMethods(@NotNull Stream<CtMethod<?>> methods) {
        return methods.filter(this.methodsFilter).filter(m -> !(m.getDeclaringType() instanceof CtInterface) || m.isDefaultMethod()).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    @NotNull
    private Set<CtType<?>> collectInterfaces(@Nullable CtType<?> ctType, @NotNull Set<CtType<?>> resultSetInitializer, int depth) {
        if (ctType == null || depth <= 0 || ctType.getSuperInterfaces().isEmpty() || ctType.isAnnotationType()) {
            return Collections.emptySet();
        }
        for (CtTypeReference superInterface : ctType.getSuperInterfaces()) {
            CtType<?> typeDeclaration = this.getTypeDeclaration(superInterface);
            if (!(typeDeclaration instanceof CtInterface)) continue;
            resultSetInitializer.add(typeDeclaration);
            resultSetInitializer.addAll(this.collectInterfaces(typeDeclaration, resultSetInitializer, depth - 1));
        }
        return resultSetInitializer;
    }

    @NotNull
    private Set<CtType<?>> collectAllSuperTypesAndInterfaces(@Nullable CtType<?> type, @NotNull Set<CtType<?>> resultSetInitializer, int depth) {
        if (type == null || depth <= 0) {
            return Collections.emptySet();
        }
        resultSetInitializer.addAll(this.collectInterfaces(type, resultSetInitializer, depth));
        CtType<?> superTypeDeclaration = this.getTypeDeclaration(type.getSuperclass());
        if (superTypeDeclaration != null) {
            resultSetInitializer.add(superTypeDeclaration);
            resultSetInitializer.addAll(this.collectAllSuperTypesAndInterfaces(superTypeDeclaration, resultSetInitializer, depth - 1));
        }
        return resultSetInitializer;
    }

    private int getMethodCharacteristic(@NotNull CtMethod<?> method) {
        LinkedList<Integer> methodCharacteristics = new LinkedList<Integer>();
        methodCharacteristics.add(method.getSimpleName().length());
        methodCharacteristics.add(method.getParameters().size());
        methodCharacteristics.addAll(method.getParameters().stream().map(parameter -> parameter.getType().getSimpleName().length()).collect(Collectors.toList()));
        CtTypeReference returnType = method.getType();
        if (returnType instanceof CtArrayTypeReference) {
            returnType = ((CtArrayTypeReference)returnType).getArrayType();
        }
        int methodReturnTypeCharacteristic = 0;
        if (returnType != null && returnType.isPrimitive()) {
            switch (RulesUtils.getTypeName(returnType)) {
                case "void": {
                    methodReturnTypeCharacteristic = -11;
                    break;
                }
                case "byte": {
                    methodReturnTypeCharacteristic = -13;
                    break;
                }
                case "short": {
                    methodReturnTypeCharacteristic = -17;
                    break;
                }
                case "char": {
                    methodReturnTypeCharacteristic = -19;
                    break;
                }
                case "int": {
                    methodReturnTypeCharacteristic = -23;
                    break;
                }
                case "long": {
                    methodReturnTypeCharacteristic = -29;
                    break;
                }
                case "float": {
                    methodReturnTypeCharacteristic = -31;
                    break;
                }
                case "double": {
                    methodReturnTypeCharacteristic = -37;
                    break;
                }
            }
            if (returnType.getParent() instanceof CtArrayTypeReference) {
                methodReturnTypeCharacteristic *= 41;
            }
        }
        methodCharacteristics.add(methodReturnTypeCharacteristic);
        int result = 1;
        Iterator iterator = methodCharacteristics.iterator();
        while (iterator.hasNext()) {
            int characteristic = (Integer)iterator.next();
            result = 31 * result + characteristic;
        }
        return result;
    }

    @Nullable
    private CtPackage getPackage(@NotNull CtType<?> type) {
        return type.isAnonymous() || type.isLocalType() ? type.getTopLevelType().getPackage() : type.getPackage();
    }

    private boolean couldBeOverridden(@NotNull CtMethod<?> child, @NotNull CtMethod<?> parent) {
        if (child.getParameters().size() != parent.getParameters().size()) {
            return false;
        }
        if (child.isStatic() || child.isPrivate() || parent.isStatic() || parent.isPrivate() || parent.isFinal()) {
            return false;
        }
        CtPackage childPackage = this.getPackage(child.getDeclaringType());
        CtPackage parentPackage = this.getPackage(parent.getDeclaringType());
        if (childPackage == null || parentPackage == null) {
            return false;
        }
        return Objects.equals(childPackage.getQualifiedName(), parentPackage.getQualifiedName()) || parent.isPublic() || parent.isProtected() || parent.isDefaultMethod();
    }

    private boolean isCovariantReturnTypes(@Nullable CtTypeReference<?> childType, @Nullable CtTypeReference<?> parentType) {
        if (childType == null || parentType == null) {
            return false;
        }
        try {
            return childType.isSubtypeOf(parentType);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private boolean isOverriding(@NotNull CtMethod<?> childMethod, @NotNull CtMethod<?> parentMethod) {
        try {
            return this.couldBeOverridden(childMethod, parentMethod) && this.isCovariantReturnTypes(childMethod.getType(), parentMethod.getType()) && childMethod.isOverriding(parentMethod);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private void apply(@NotNull CtMethod<?> childMethod, @NotNull CtMethod<?> parentMethod) {
        PvsStudioRule.Pattern pattern;
        List parentMethodParameters;
        if (this.hasJunitAnnotation(childMethod) || this.hasJunitAnnotation(parentMethod)) {
            return;
        }
        MethodNameEquality methodNameEquality = this.getMethodNameEquality(childMethod.getSimpleName(), parentMethod.getSimpleName());
        if (methodNameEquality == MethodNameEquality.RuleException) {
            return;
        }
        if (!this.isCovariantReturnTypes(childMethod.getType(), parentMethod.getType())) {
            return;
        }
        List childMethodParameters = childMethod.getParameters();
        int indexOnlyOneNotSameTypeArgument = this.getIndexOnlyOneNotSameTypeArgument(childMethodParameters, parentMethodParameters = parentMethod.getParameters());
        boolean hasOnlyOneNotSameTypeArgument = indexOnlyOneNotSameTypeArgument >= 0;
        CtParameter childParameter = null;
        CtParameter parentParameter = null;
        if (hasOnlyOneNotSameTypeArgument) {
            childParameter = (CtParameter)childMethodParameters.get(indexOnlyOneNotSameTypeArgument);
            parentParameter = (CtParameter)parentMethodParameters.get(indexOnlyOneNotSameTypeArgument);
        }
        boolean couldBeOverridden = this.couldBeOverridden(childMethod, parentMethod);
        String baseClassName = parentMethod.getPosition().isValidPosition() ? "base" : "'" + parentMethod.getDeclaringType().getSimpleName() + "'";
        ArrayList<Object> messageObjects = new ArrayList<Object>();
        messageObjects.add(childMethod.getSimpleName());
        if (methodNameEquality == MethodNameEquality.NamesEquals && hasOnlyOneNotSameTypeArgument && couldBeOverridden && this.equalsSimpleAndNotEqualsQualifiedTypesNames(childParameter, parentParameter)) {
            pattern = this.wrongParameterType;
            messageObjects.add(baseClassName);
            if (indexOnlyOneNotSameTypeArgument < this.parametersPositionNames.size()) {
                messageObjects.add(this.parametersPositionNames.get(indexOnlyOneNotSameTypeArgument));
            } else {
                messageObjects.add(indexOnlyOneNotSameTypeArgument + "-th");
            }
        } else if (methodNameEquality == MethodNameEquality.NamesEquals && !hasOnlyOneNotSameTypeArgument && !couldBeOverridden) {
            pattern = this.parentMethodIsPackagePrivate;
            messageObjects.add(baseClassName);
        } else if (methodNameEquality == MethodNameEquality.CamelCaseTypo && !hasOnlyOneNotSameTypeArgument && couldBeOverridden) {
            pattern = this.camelCaseTypo;
            messageObjects.add(parentMethod.getSimpleName());
            messageObjects.add(baseClassName);
        } else {
            return;
        }
        WarningAdapter warningAdapter = pattern.add((CtElement)childMethod, messageObjects.toArray()).addSourcePosition((CtElement)parentMethod, this.getModule());
        if (objectTypeMethodsCanBeOverride.contains(parentMethod)) {
            warningAdapter.setLevel(WarningLevel.LEVEL_1);
        }
    }

    private void apply(@NotNull Set<CtMethod<?>> childMethods, @NotNull Set<CtMethod<?>> parentMethods) {
        if (childMethods.isEmpty() || parentMethods.isEmpty()) {
            return;
        }
        Map<Integer, Set> childMethodsCharacteristics = childMethods.stream().collect(Collectors.groupingBy(this::getMethodCharacteristic, Collectors.mapping(m -> m, Collectors.toCollection(Sets::newIdentityHashSet))));
        Map<Integer, Set> parentMethodsCharacteristics = parentMethods.stream().collect(Collectors.groupingBy(this::getMethodCharacteristic, Collectors.mapping(m -> m, Collectors.toCollection(Sets::newIdentityHashSet))));
        Set childNonOverridingMethods = Sets.newIdentityHashSet();
        HashMap<Integer, Set> parentNonOverriddenMethods = new HashMap<Integer, Set>();
        HashSet<Integer> methodCharacteristics = new HashSet<Integer>(childMethodsCharacteristics.keySet());
        methodCharacteristics.addAll(parentMethodsCharacteristics.keySet());
        for (Integer methodCharacteristic : methodCharacteristics) {
            Set childMethodsGroup = childMethodsCharacteristics.get(methodCharacteristic);
            Set parentMethodsGroup = parentMethodsCharacteristics.get(methodCharacteristic);
            if (childMethodsGroup == null || parentMethodsGroup == null) continue;
            Set childMethodsGroupTemp = Sets.newIdentityHashSet();
            childMethodsGroupTemp.addAll(childMethodsGroup);
            Set parentMethodsGroupTemp = Sets.newIdentityHashSet();
            parentMethodsGroupTemp.addAll(parentMethodsGroup);
            for (CtMethod childMethod2 : childMethodsGroup) {
                for (CtMethod parentMethod : parentMethodsGroup) {
                    if (!this.isOverriding(childMethod2, parentMethod)) continue;
                    childMethodsGroupTemp.remove(childMethod2);
                    parentMethodsGroupTemp.remove(parentMethod);
                }
            }
            childMethodsGroupTemp.removeIf(childMethod -> childMethod.hasAnnotation(Override.class));
            childNonOverridingMethods.addAll(childMethodsGroupTemp);
            parentNonOverriddenMethods.computeIfPresent(methodCharacteristic, (key, value) -> Sets.union((Set)value, (Set)parentMethodsGroupTemp));
            parentNonOverriddenMethods.putIfAbsent(methodCharacteristic, parentMethodsGroupTemp);
        }
        for (CtMethod childMethod3 : childNonOverridingMethods) {
            Set parentNonOverriddenMethodsGroup = (Set)parentNonOverriddenMethods.get(this.getMethodCharacteristic(childMethod3));
            if (parentNonOverriddenMethodsGroup == null) continue;
            for (CtMethod parentMethod : parentNonOverriddenMethodsGroup) {
                this.apply(childMethod3, parentMethod);
            }
        }
    }

    @NotNull
    private MethodNameEquality getMethodNameEquality(@NotNull String childMethodName, @NotNull String parentMethodName) {
        if (Objects.equals(childMethodName, parentMethodName)) {
            return MethodNameEquality.NamesEquals;
        }
        if (Objects.equals(childMethodName.toLowerCase(), parentMethodName.toLowerCase())) {
            return MethodNameEquality.CamelCaseTypo;
        }
        return MethodNameEquality.RuleException;
    }

    private int getIndexOnlyOneNotSameTypeArgument(@NotNull List<CtParameter<?>> childParameters, @NotNull List<CtParameter<?>> parentParameters) {
        if (childParameters.size() != parentParameters.size()) {
            return -1;
        }
        int notSameParameterTypeIndex = -1;
        for (int i = 0; i < childParameters.size(); ++i) {
            if (Objects.equals(childParameters.get(i).getType(), parentParameters.get(i).getType())) continue;
            if (notSameParameterTypeIndex == -1) {
                notSameParameterTypeIndex = i;
                continue;
            }
            return -1;
        }
        return notSameParameterTypeIndex;
    }

    private boolean equalsSimpleAndNotEqualsQualifiedTypesNames(@Nullable CtParameter<?> childParameter, @Nullable CtParameter<?> parentParameter) {
        if (childParameter == null || parentParameter == null) {
            return false;
        }
        CtTypeReference childType = childParameter.getType();
        CtTypeReference parentType = parentParameter.getType();
        if (childType == null || parentType == null) {
            return false;
        }
        return Objects.equals(childType.getSimpleName(), parentType.getSimpleName()) && !Objects.equals(childType.getQualifiedName(), parentType.getQualifiedName());
    }

    private boolean hasJunitAnnotation(@NotNull CtMethod<?> method) {
        return method.getAnnotations().stream().anyMatch(annotation -> annotation.getAnnotationType().getQualifiedName().startsWith("org.junit"));
    }

    @Nullable
    private CtType<?> getTypeDeclaration(@Nullable CtTypeReference<?> ref) {
        if (ref == null) {
            return null;
        }
        CtType declaration = ref.getDeclaration();
        if (declaration != null) {
            return declaration;
        }
        return ref.getTypeDeclaration();
    }

    private static enum MethodNameEquality {
        NamesEquals,
        CamelCaseTypo,
        RuleException;

    }
}

